/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.InviteDetailEntity;
import com.ejianc.business.fjwz.bean.ScarpEntity;
import com.ejianc.business.fjwz.service.IInviteDetailService;
import com.ejianc.business.fjwz.service.IScarpDetailService;
import com.ejianc.business.fjwz.service.IScarpService;
import com.ejianc.business.fjwz.vo.ScarpDetailVO;
import com.ejianc.business.fjwz.vo.ScarpVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scarp"})
public class ScarpController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCARP";
    @Autowired
    private IScarpService service;
    @Autowired
    private IScarpDetailService detailService;
    @Autowired
    private IInviteDetailService inviteDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ScarpVO> saveOrUpdate(@RequestBody ScarpVO saveOrUpdateVO) {
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (null == saveOrUpdateVO.getId() && codeBatchByRuleCode.isSuccess()) {
            saveOrUpdateVO.setBillCode((String)codeBatchByRuleCode.getData());
        }
        List detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        saveOrUpdateVO.setMaterialTypeNames(materialTypeNames);
        if (saveOrUpdateVO.getType() == 1) {
            ArrayList<InviteDetailEntity> list = new ArrayList<InviteDetailEntity>();
            for (ScarpDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                InviteDetailEntity inviteDetailEntity = (InviteDetailEntity)((Object)this.inviteDetailService.selectById((Serializable)((Object)detailVO.getSourceId())));
                inviteDetailEntity.setOutNum(ComputeUtil.safeAdd((BigDecimal)inviteDetailEntity.getOutNum(), (BigDecimal)detailVO.getNum()));
                list.add(inviteDetailEntity);
            }
            this.inviteDetailService.saveOrUpdateBatch(list);
        }
        ScarpEntity entity = (ScarpEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ScarpEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ScarpVO vo = (ScarpVO)BeanMapper.map((Object)((Object)entity), ScarpVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ScarpVO> queryDetail(Long id) {
        ScarpEntity entity = (ScarpEntity)((Object)this.service.selectById(id));
        ScarpVO vo = (ScarpVO)BeanMapper.map((Object)((Object)entity), ScarpVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScarpVO> vos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<Long> scarpIds = new ArrayList<Long>();
        List entityList = new ArrayList();
        List detailEntities = new ArrayList();
        ArrayList<InviteDetailEntity> inviteDetailEntityList = new ArrayList<InviteDetailEntity>();
        if (ListUtil.isNotEmpty(vos)) {
            for (ScarpVO vo : vos) {
                ids.add(vo.getId());
            }
            entityList = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", ids)).eq((Object)"type", (Object)1));
        }
        if (ListUtil.isNotEmpty(entityList)) {
            for (BaseEntity entity : entityList) {
                scarpIds.add(entity.getId());
            }
            detailEntities = this.detailService.list((Wrapper)new QueryWrapper().in((Object)"scarp_id", scarpIds));
            for (BaseEntity entity : detailEntities) {
                InviteDetailEntity inviteDetailEntity = (InviteDetailEntity)((Object)this.inviteDetailService.selectById((Serializable)((Object)entity.getSourceId())));
                inviteDetailEntity.setOutNum(ComputeUtil.safeSub((BigDecimal)inviteDetailEntity.getOutNum(), (BigDecimal)entity.getNum()));
                inviteDetailEntityList.add(inviteDetailEntity);
            }
            this.inviteDetailService.saveOrUpdateBatch(inviteDetailEntityList);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ScarpVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScarpVO.class));
        for (ScarpVO vo : pageData.getRecords()) {
            switch (vo.getPayState()) {
                case 0: {
                    vo.setPayStateName("\u5df2\u652f\u4ed8");
                    break;
                }
                case 1: {
                    vo.setPayStateName("\u672a\u652f\u4ed8");
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = BeanMapper.mapList((Iterable)this.service.queryList(param), ScarpVO.class);
        for (ScarpVO vo : list) {
            switch (vo.getPayState()) {
                case 0: {
                    vo.setPayStateName("\u5df2\u652f\u4ed8");
                    break;
                }
                case 1: {
                    vo.setPayStateName("\u672a\u652f\u4ed8");
                }
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("scarp-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refScarpData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ScarpVO>> refScarpData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScarpVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryParentOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse orgVO = this.iOrgApi.detailById(((OrgVO)this.iOrgApi.detailById(orgId).getData()).getParentId());
        return CommonResponse.success((Object)orgVO.getData());
    }
}

