/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentRecordEntity;
import com.ejianc.business.fjwz.bean.DocumentSellEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.bean.TalkEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.mapper.DocumentMapper;
import com.ejianc.business.fjwz.service.IDocumentRecordService;
import com.ejianc.business.fjwz.service.IDocumentSellService;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IDocumentSupplierService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.service.ITalkService;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.DocumentRecordVO;
import com.ejianc.business.fjwz.vo.DocumentSellVO;
import com.ejianc.business.fjwz.vo.DocumentSupplierVO;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.GF.UpdateGFVO;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.business.fjwz.vo.InviteSupplierVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="documentService")
public class DocumentServiceImpl
extends BaseServiceImpl<DocumentMapper, DocumentEntity>
implements IDocumentService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "cscec5b-document-code";
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ITalkService talkService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    @Autowired
    private IProjectApi projectApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.updateTimeOrStateUrl}")
    private String updateTimeOrStateUrl;
    @Value(value="${openApi.wjFjwzInsertUrl}")
    private String wjFjwzInsertUrl;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public DocumentVO saveDocument(Long inviteId) {
        DocumentEntity entity = new DocumentEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(inviteId));
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectSourceId(inviteEntity.getProjectSourceId());
        entity.setInviteId(inviteId);
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgSourceId(inviteEntity.getParentOrgSourceId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectCode(inviteEntity.getProjectCode());
        entity.setDocumentName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        entity.setUnitSourceId(inviteEntity.getUnitSourceId());
        entity.setDoucumentLinkId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setDoucumentLinkName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        super.saveOrUpdate((Object)entity, false);
        inviteEntity.setTenderStage(TenderStageEnum.DOCUMENT.getChangeStateCode());
        inviteEntity.setNextFlag(1);
        this.inviteService.updateById((Object)inviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u8be2\u4ef7\u516c\u544a");
        processEntity.setTenderId(inviteEntity.getId());
        processEntity.setFrontendUrl("invite/documentCard");
        this.processService.saveOrUpdate((Object)processEntity);
        DocumentVO vo = (DocumentVO)BeanMapper.map((Object)((Object)entity), DocumentVO.class);
        vo.setInviteDetailList(BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class));
        vo.setInviteSupplierList(BeanMapper.mapList(inviteEntity.getInviteSupplierlList(), InviteSupplierVO.class));
        vo.setTenderStage(inviteEntity.getTenderStage());
        return vo;
    }

    @Override
    @Transactional
    public DocumentVO publishDocument(Long id) {
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)id));
        documentEntity.setPublishFlag(0);
        super.updateById((Object)documentEntity);
        DocumentVO documentVO = this.queryDetail(id);
        List inviteDetailList = documentVO.getInviteDetailList();
        String disposeContent = inviteDetailList.stream().map(InviteDetailVO::getMaterialTypeName).collect(Collectors.joining(","));
        documentVO.setDisposeContent(disposeContent);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        String back = null;
        try {
            this.logger.info("---url:" + this.wjFjwzInsertUrl);
            this.logger.info("---\u8be2\u4ef7\u516c\u544a\u53d1\u5e03\u5165\u53c2:" + JSONObject.toJSON((Object)documentVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(this.wjFjwzInsertUrl, JSONObject.toJSON((Object)documentVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if (!"200".equals(jsonBack.getString("code"))) {
                throw new BusinessException(jsonBack.getString("msg"));
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u516c\u544a\u4fe1\u606f\u5931\u8d25");
        }
        return this.queryDetail(id);
    }

    @Override
    public Boolean supplierPushSell(DocumentSupplierVO documentSupplierVO) {
        String s = JSONObject.toJSONString((Object)documentSupplierVO);
        this.logger.info("\u62a5\u4ef7\u5b9e\u4f53:" + s);
        Integer talkNum = documentSupplierVO.getTalkNum();
        Long inviteId = documentSupplierVO.getInviteId();
        Long supplierId = documentSupplierVO.getSupplierId();
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, (Object)inviteId);
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.getOne((Wrapper)lambdaDoc));
        Long documentEntityId = documentEntity.getId();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, (Object)talkNum);
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentEntityId);
        lambdaSupplier.eq(DocumentSupplierEntity::getSupplierId, (Object)supplierId);
        this.documentSupplierService.remove((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)documentEntityId);
        lambdaSell.eq(DocumentSellEntity::getSupplierId, (Object)supplierId);
        this.documentSellService.remove((Wrapper)lambdaSell);
        DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)BeanMapper.map((Object)documentSupplierVO, DocumentSupplierEntity.class));
        documentSupplierEntity.setDocumentId(documentEntityId);
        this.documentSupplierService.save((Object)documentSupplierEntity);
        List documentSellEntityList = BeanMapper.mapList((Iterable)documentSupplierVO.getDocumentSellList(), DocumentSellEntity.class);
        documentSellEntityList.forEach(p -> p.setDocumentId(documentEntityId));
        this.documentSellService.saveBatch(documentSellEntityList);
        return true;
    }

    @Override
    public DocumentSupplierVO getSellInfoById(Long supplierId, Long documentId) {
        DocumentSupplierVO documentSupplierVO = this.getSellInfo(supplierId, documentId, 0);
        return documentSupplierVO;
    }

    private DocumentSupplierVO getSellInfo(Long supplierId, Long documentId, Integer talkNum) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, (Object)talkNum);
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentId);
        lambdaSupplier.eq(DocumentSupplierEntity::getSupplierId, (Object)supplierId);
        DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)this.documentSupplierService.getOne((Wrapper)lambdaSupplier));
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)documentId);
        lambdaSell.eq(DocumentSellEntity::getSupplierId, (Object)supplierId);
        List documentSellEntityList = this.documentSellService.list((Wrapper)lambdaSell);
        DocumentSupplierVO documentSupplierVO = (DocumentSupplierVO)BeanMapper.map((Object)((Object)documentSupplierEntity), DocumentSupplierVO.class);
        List documentSellVOS = BeanMapper.mapList((Iterable)documentSellEntityList, DocumentSellVO.class);
        documentSupplierVO.setDocumentSellList(documentSellVOS);
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)documentId));
        documentSupplierVO.setBidFlag(documentEntity.getBidFlag());
        return documentSupplierVO;
    }

    @Override
    public DocumentVO bidDocument(Long id) {
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)id));
        documentEntity.setBidFlag(0);
        documentEntity.setBidTime(new Date());
        super.updateById((Object)documentEntity);
        UpdateGFVO updateGFVO = new UpdateGFVO();
        updateGFVO.setType(Integer.valueOf(2));
        updateGFVO.setSourceId(Long.toString(documentEntity.getInviteId()));
        updateGFVO.setBillDate(documentEntity.getBidTime());
        updateGFVO.setPkCreator("hnxpt");
        updateGFVO.setSysmark("hnxpt");
        updateGFVO.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        updateGFVO.setCreatorDate(simpleDateFormat.format(new Date()));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        String back = null;
        try {
            this.logger.info("---url:" + this.updateTimeOrStateUrl);
            this.logger.info("---\u5f00\u6807\u63a8\u9001\u4f9b\u65b9\u5165\u53c2:" + JSONObject.toJSON((Object)updateGFVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(this.updateTimeOrStateUrl, JSONObject.toJSON((Object)updateGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if (!"200".equals(jsonBack.getString("code"))) {
                throw new BusinessException(jsonBack.getString("msg"));
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u516c\u544a\u4fe1\u606f\u5931\u8d25");
        }
        return this.queryDetail(id);
    }

    @Override
    public DocumentVO extendDocument(DocumentRecordVO documentRecordVO) {
        DocumentRecordEntity documentRecordEntity = (DocumentRecordEntity)((Object)BeanMapper.map((Object)documentRecordVO, DocumentRecordEntity.class));
        this.documentRecordService.save((Object)documentRecordEntity);
        DocumentEntity stuffDocumentEntity = (DocumentEntity)((Object)super.selectById((Serializable)documentRecordVO.getDocumentId()));
        stuffDocumentEntity.setOfferEndTime(documentRecordVO.getNewTime());
        boolean b = super.updateById((Object)stuffDocumentEntity);
        UpdateGFVO updateGFVO = new UpdateGFVO();
        updateGFVO.setBillDate(documentRecordVO.getNewTime());
        updateGFVO.setType(Integer.valueOf(0));
        updateGFVO.setSourceId(Long.toString(stuffDocumentEntity.getInviteId()));
        updateGFVO.setPkCreator("hnxpt");
        updateGFVO.setSysmark("hnxpt");
        updateGFVO.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        updateGFVO.setCreatorDate(simpleDateFormat.format(documentRecordVO.getNewTime()));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        String back = null;
        try {
            this.logger.info("---url:" + this.updateTimeOrStateUrl);
            this.logger.info("---\u8be2\u4ef7\u516c\u544a\u5ef6\u957f\u65f6\u95f4\u5165\u53c2:" + JSONObject.toJSON((Object)updateGFVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(this.updateTimeOrStateUrl, JSONObject.toJSON((Object)updateGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if (!"200".equals(jsonBack.getString("code"))) {
                throw new BusinessException(jsonBack.getString("msg"));
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u516c\u544a\u4fe1\u606f\u5931\u8d25");
        }
        return null;
    }

    @Override
    public DocumentVO queryDetail(Long id) {
        return this.queryDocDetail(id, 0);
    }

    @Override
    public DocumentVO queryDocDetail(Long id, Integer talkNum) {
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.selectById((Serializable)id));
        DocumentVO documentVO = (DocumentVO)BeanMapper.map((Object)((Object)documentEntity), DocumentVO.class);
        Long inviteId = documentEntity.getInviteId();
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(inviteId));
        documentVO.setInviteSupplierList(BeanMapper.mapList(inviteEntity.getInviteSupplierlList(), InviteSupplierVO.class));
        documentVO.setInviteDetailList(BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class));
        documentVO.setInviteName(inviteEntity.getTenderName());
        List documentSupplierList = documentVO.getDocumentSupplierList();
        List documentSupplierVOS = documentSupplierList.stream().filter(s -> s.getTalkNum().equals(talkNum)).collect(Collectors.toList());
        if (documentVO.getBidFlag() == 1) {
            for (DocumentSupplierVO documentSupplierVO : documentSupplierVOS) {
                documentSupplierVO.setTenderDate(null);
                documentSupplierVO.setOfferTime(null);
                documentSupplierVO.setMemo(null);
                documentSupplierVO.setLinkId(null);
                documentSupplierVO.setLinkMobile(null);
                documentSupplierVO.setLinkName(null);
                documentSupplierVO.setTaxMemo(null);
            }
        }
        documentVO.setDocumentSupplierList(documentSupplierVOS);
        documentVO.setDocumentSupplierSellList(documentSupplierVOS);
        List inviteDetailVOS = BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, (Object)id);
        List documentSellEntityList = this.documentSellService.list((Wrapper)lambdaSell);
        List documentSellVOS = BeanMapper.mapList((Iterable)documentSellEntityList, DocumentSellVO.class);
        Map<Long, List<DocumentSellVO>> sellMap = documentSellVOS.stream().collect(Collectors.groupingBy(DocumentSellVO::getInviteDetailId));
        for (InviteDetailVO inviteDetailVO : inviteDetailVOS) {
            if (!sellMap.containsKey(inviteDetailVO.getId())) continue;
            List<DocumentSellVO> documentSellList = sellMap.get(inviteDetailVO.getId());
            if (documentVO.getBidFlag() == 1) {
                for (DocumentSellVO documentSellVO : documentSellList) {
                    documentSellVO.setSupplierMemo(null);
                    documentSellVO.setPriceTax(null);
                    documentSellVO.setSellMoneyTax(null);
                }
            }
            inviteDetailVO.setDocumentSupplierSellList(documentSellList);
        }
        documentVO.setDetailSupplierList(inviteDetailVOS);
        documentVO.setTenderStage(inviteEntity.getTenderStage());
        return documentVO;
    }

    @Override
    public DocumentSupplierVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        TalkEntity talkEntity = (TalkEntity)((Object)this.talkService.selectById(talkId));
        LambdaQueryWrapper lambdaDocSupplier = Wrappers.lambdaQuery();
        lambdaDocSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)talkEntity.getDocumentId());
        List documentSupplierEntities = this.documentSupplierService.list((Wrapper)lambdaDocSupplier);
        Map talkSupplierMap = documentSupplierEntities.stream().collect(Collectors.toMap(DocumentSupplierEntity::getTalkNum, Function.identity()));
        Integer talkNum = talkEntity.getTalkNum();
        if (talkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ArrayList<DocumentSupplierVO> talkVOArrayList = new ArrayList<DocumentSupplierVO>();
        String name = null;
        for (int a = 0; a <= talkNum; ++a) {
            DocumentSupplierVO documentSupplierVO = new DocumentSupplierVO();
            documentSupplierVO.setTalkNum(Integer.valueOf(a));
            name = a == 0 ? "\u9996\u6b21\u62a5\u4ef7" : "\u7b2c" + a + "\u8f6e\u62a5\u4ef7";
            DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)talkSupplierMap.get(a));
            documentSupplierVO.setTalkNumName(name);
            documentSupplierVO.setMoneyTax(documentSupplierEntity.getMoneyTax());
            documentSupplierVO.setTalkNum(Integer.valueOf(a));
            talkVOArrayList.add(documentSupplierVO);
        }
        DocumentSupplierVO documentSupplierVO = new DocumentSupplierVO();
        DocumentSupplierEntity documentSupplierEntity = (DocumentSupplierEntity)((Object)this.documentSupplierService.selectById(supplierDetailId));
        documentSupplierVO.setLinkName(documentSupplierEntity.getLinkName());
        documentSupplierVO.setLinkMobile(documentSupplierEntity.getLinkMobile());
        documentSupplierVO.setOfferTime(documentSupplierEntity.getOfferTime());
        documentSupplierVO.setTaxMemo(documentSupplierEntity.getTaxMemo());
        documentSupplierVO.setSupplierName(documentSupplierEntity.getSupplierName());
        LambdaQueryWrapper lambdaDocSell = Wrappers.lambdaQuery();
        lambdaDocSell.eq(DocumentSellEntity::getDocumentId, (Object)talkEntity.getDocumentId());
        lambdaDocSell.eq(DocumentSellEntity::getSupplierId, (Object)documentSupplierEntity.getSupplierId());
        List documentSellEntities = this.documentSellService.list((Wrapper)lambdaDocSell);
        ArrayList documentSellTalk = new ArrayList();
        for (DocumentSupplierVO documentSupplier : talkVOArrayList) {
            Integer talkN = documentSupplier.getTalkNum();
            List documentSellEntityList = documentSellEntities.stream().filter(s -> s.getTalkNum().equals(talkN)).collect(Collectors.toList());
            List documentSellVOS = BeanMapper.mapList(documentSellEntityList, DocumentSellVO.class);
            documentSupplier.setDocumentSellList(documentSellVOS);
        }
        List documentSupplierVOS = talkVOArrayList.stream().sorted(Comparator.comparing(DocumentSupplierVO::getTalkNum).reversed()).collect(Collectors.toList());
        documentSupplierVO.setDocumentTalkList(documentSupplierVOS);
        return documentSupplierVO;
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public DocumentSupplierVO getPicSellInfoById(Long inviteId, Long supplierId) {
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, (Object)inviteId);
        DocumentEntity documentEntity = (DocumentEntity)((Object)super.getOne((Wrapper)lambdaDoc));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentEntity.getId());
        List supplierEntityList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        DocumentSupplierVO documentSupplierVO = this.getSellInfo(supplierId, documentEntity.getId(), talkNumMax);
        return documentSupplierVO;
    }
}

