/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.service.impl;

import com.ejianc.business.fjwz.bean.InviteDetailEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.mapper.InviteMapper;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.vo.InviteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inviteService")
public class InviteServiceImpl
extends BaseServiceImpl<InviteMapper, InviteEntity>
implements IInviteService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProcessService processService;
    private static final String BILL_CODE = "cscec5b-invite-code";

    @Override
    public InviteVO saveOrUpdate(InviteVO saveOrUpdateVO) {
        InviteEntity inviteEntity = (InviteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InviteEntity.class));
        if (inviteEntity.getId() == null || inviteEntity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                inviteEntity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        inviteEntity.setNextFlag(1);
        inviteEntity.setTenderStage(TenderStageEnum.INVITE.getChangeStateCode());
        List<InviteDetailEntity> inviteDetailList = inviteEntity.getInviteDetailList();
        String materialTypeNames = inviteDetailList.stream().map(InviteDetailEntity::getMaterialTypeName).collect(Collectors.joining(","));
        inviteEntity.setMaterialTypeNames(materialTypeNames);
        super.saveOrUpdate((Object)inviteEntity, false);
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(inviteEntity.getId());
            processEntity.setBillName("\u8be2\u4ef7\u7acb\u9879");
            processEntity.setTenderId(inviteEntity.getId());
            processEntity.setFrontendUrl("invite/card");
            this.processService.saveOrUpdate((Object)processEntity);
        }
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)inviteEntity), InviteVO.class);
        return vo;
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        InviteEntity inviteEntity = (InviteEntity)((Object)super.selectById((Serializable)tenderId));
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)inviteEntity), InviteVO.class);
        Integer status = 0;
        if (vo.getTenderStage().equals(TenderStageEnum.WASTE.getChangeStateCode())) {
            status = 1;
        }
        map.put("abolishType", status);
        map.put("employeeId", vo.getEmployeeId());
        return map;
    }
}

