/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.PicketageEntity;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IDocumentSupplierService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IPicketageService;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.GF.UpdateGFVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="picketage")
public class PicketageBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPicketageService picketageService;
    @Autowired
    private IDocumentService documentService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IInviteService inviteService;
    @Value(value="${openApi.updateTimeOrStateUrl}")
    private String updateTimeOrStateUrl;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PicketageEntity picketageEntity = (PicketageEntity)((Object)this.picketageService.selectById(billId));
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, (Object)picketageEntity.getInviteId());
        DocumentEntity documentEntity = (DocumentEntity)((Object)this.documentService.getOne((Wrapper)lambdaDoc));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, (Object)documentEntity.getId());
        List supplierEntityList = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        LambdaQueryWrapper lambdaSupplierBid = Wrappers.lambdaQuery();
        lambdaSupplierBid.eq(DocumentSupplierEntity::getTalkNum, (Object)talkNumMax);
        lambdaSupplierBid.eq(DocumentSupplierEntity::getDocumentId, (Object)documentEntity.getId());
        List supplierEntities = this.documentSupplierService.list((Wrapper)lambdaSupplier);
        DocumentSupplierEntity documentSupplierEntity = supplierEntities.stream().filter(s -> s.getTenderFlag() == 1).findFirst().get();
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(documentEntity.getInviteId()));
        inviteEntity.setSupplierSourceId(documentSupplierEntity.getSupplierSourceId());
        inviteEntity.setSupplierId(documentSupplierEntity.getSupplierId());
        inviteEntity.setSupplierName(documentSupplierEntity.getSupplierName());
        this.inviteService.updateById((Object)inviteEntity);
        this.pushSupplier(picketageEntity, documentSupplierEntity);
        return CommonResponse.success();
    }

    private void pushSupplier(PicketageEntity picketageEntity, DocumentSupplierEntity documentSupplierEntity) {
        UpdateGFVO updateGFVO = new UpdateGFVO();
        updateGFVO.setType(Integer.valueOf(3));
        updateGFVO.setSourceId(Long.toString(picketageEntity.getInviteId()));
        updateGFVO.setPkSupplier(documentSupplierEntity.getSupplierSourceId());
        updateGFVO.setSupplierName(documentSupplierEntity.getSupplierName());
        updateGFVO.setSupplierSourceId(documentSupplierEntity.getSupplierId());
        updateGFVO.setBillDate(picketageEntity.getPicketageTime());
        updateGFVO.setPkCreator("hnxpt");
        updateGFVO.setSysmark("hnxpt");
        updateGFVO.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        updateGFVO.setCreatorDate(simpleDateFormat.format(new Date()));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.documentService.getAccessToken(headers);
        String back = null;
        try {
            this.logger.info("---url:" + this.updateTimeOrStateUrl);
            this.logger.info("---\u5b9a\u6807\u56de\u5199\u5165\u53c2:" + JSONObject.toJSON((Object)updateGFVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(this.updateTimeOrStateUrl, JSONObject.toJSON((Object)updateGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if (!"200".equals(jsonBack.getString("code"))) {
                throw new BusinessException(jsonBack.getString("msg"));
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u516c\u544a\u4fe1\u606f\u5931\u8d25");
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u529f\u80fd\u4e0d\u652f\u6301\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

