package com.ejianc.business.fjwz.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fjwz.bean.DocumentRecordEntity;
import com.ejianc.business.fjwz.bean.DocumentSellEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
/**
 * 询价公告-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fjwz_document")
public class DocumentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标立项主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="document_name")
    private String documentName; // 公告名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="employee_id")
    private Long employeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="value_type")
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织name
    @TableField(value="parent_org_source_id")
    private String parentOrgSourceId; // 父级组织来源id
    @TableField(value="doucument_link_id")
    private Long doucumentLinkId; // 询价联系人id
    @TableField(value="doucument_link_name")
    private String doucumentLinkName; // 询价联系人name
    @TableField(value="doucument_link_mobile")
    private String doucumentLinkMobile; // 询价联系人电话
    @TableField(value="offer_start_time")
    private Date offerStartTime; // 询价开始时间
    @TableField(value="offer_end_time")
    private Date offerEndTime; // 询价结束时间
    @TableField(value="document_content")
    private String documentContent; // 文件内容
    @TableField(value="bid_flag")
    private Integer bidFlag; // 是否开标,0-是,1-否
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,0-是,1-否
    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-是,1-否
    @TableField(value="bid_time")
    private Date bidTime; // 开标时间
    @TableField(value="unit_id")
    private Long unitId; // 询价单位ID
    @TableField(value="unit_source_id")
    private String unitSourceId; // 询价单位来源ID
    @TableField(value="unit_name")
    private String unitName; // 询价单位name
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="documentRecordService",pidName = "documentId")//此处有pid="xxx"，默认值pid="pid"
    private List<DocumentRecordEntity> documentRecordList = new ArrayList<>(); // 询价公告-截止时间表
    @TableField(exist=false)
    @SubEntity(serviceName="documentSellService",pidName = "documentId")//此处有pid="xxx"，默认值pid="pid"
    private List<DocumentSellEntity> documentSellList = new ArrayList<>(); // 询价公告-报价表
    @TableField(exist=false)
    @SubEntity(serviceName="documentSupplierService",pidName = "documentId")//此处有pid="xxx"，默认值pid="pid"
    private List<DocumentSupplierEntity> documentSupplierList = new ArrayList<>(); // 询价公告-报价供应商表
    

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getDocumentName() {
        return documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public Long getDoucumentLinkId() {
        return doucumentLinkId;
    }

    public void setDoucumentLinkId(Long doucumentLinkId) {
        this.doucumentLinkId = doucumentLinkId;
    }
    public String getDoucumentLinkName() {
        return doucumentLinkName;
    }

    public void setDoucumentLinkName(String doucumentLinkName) {
        this.doucumentLinkName = doucumentLinkName;
    }
    public String getDoucumentLinkMobile() {
        return doucumentLinkMobile;
    }

    public void setDoucumentLinkMobile(String doucumentLinkMobile) {
        this.doucumentLinkMobile = doucumentLinkMobile;
    }
    public Date getOfferStartTime() {
        return offerStartTime;
    }

    public void setOfferStartTime(Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    public Date getOfferEndTime() {
        return offerEndTime;
    }

    public void setOfferEndTime(Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    public String getDocumentContent() {
        return documentContent;
    }

    public void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }
    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    public Date getBidTime() {
        return bidTime;
    }

    public void setBidTime(Date bidTime) {
        this.bidTime = bidTime;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitSourceId() {
        return unitSourceId;
    }

    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
    public List<DocumentRecordEntity> getDocumentRecordList() {
        return documentRecordList;
    }

    public void setDocumentRecordList(List<DocumentRecordEntity> documentRecordList) {
        this.documentRecordList = documentRecordList;
    }
    public List<DocumentSellEntity> getDocumentSellList() {
        return documentSellList;
    }

    public void setDocumentSellList(List<DocumentSellEntity> documentSellList) {
        this.documentSellList = documentSellList;
    }
    public List<DocumentSupplierEntity> getDocumentSupplierList() {
        return documentSupplierList;
    }

    public void setDocumentSupplierList(List<DocumentSupplierEntity> documentSupplierList) {
        this.documentSupplierList = documentSupplierList;
    }
}
