package com.ejianc.business.fjwz.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fjwz.bean.InviteDetailEntity;
/**
 * 询价立项-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fjwz_invite")
public class InviteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人名称
    @TableField(value="unit_id")
    private Long unitId; // 询价单位ID
    @TableField(value="unit_source_id")
    private String unitSourceId; // 询价单位来源ID
    @TableField(value="unit_name")
    private String unitName; // 询价单位name
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="tender_name")
    private String tenderName; // 询价名称
    @TableField(value="tender_stage")
    private Integer tenderStage; // 询价阶段(0-询价立项,1-询价公告,2-洽商谈判,3-询价结果,4-终止询价)
    @TableField(value="create_date")
    private Date createDate; // 编制日期
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织name
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_source_id")
    private String parentOrgSourceId; // 上级组织来源id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织name
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商ID
    @TableField(value="supplier_name")
    private String supplierName; // 中标供应商
    @TableField(value="supplier_source_id")
    private String supplierSourceId; // 供方sourceID
    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-否,1-是
    @TableField(value="material_type_names")
    private String materialTypeNames; // 物资分类明细汇总

    
    @TableField(exist=false)
    @SubEntity(serviceName="inviteDetailService",pidName = "inviteId")//此处有pid="xxx"，默认值pid="pid"
    private List<InviteDetailEntity> inviteDetailList = new ArrayList<>(); // 询价立项-子表
    @TableField(exist=false)
    @SubEntity(serviceName="inviteSupplierService",pidName = "inviteId")//此处有pid="xxx"，默认值pid="pid"
    private List<InviteSupplierEntity> inviteSupplierlList = new ArrayList<>(); // 询价立项-供应商表

    public List<InviteSupplierEntity> getInviteSupplierlList() {
        return inviteSupplierlList;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public void setInviteSupplierlList(List<InviteSupplierEntity> inviteSupplierlList) {
        this.inviteSupplierlList = inviteSupplierlList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitSourceId() {
        return unitSourceId;
    }

    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    public Integer getTenderStage() {
        return tenderStage;
    }

    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    
    public List<InviteDetailEntity> getInviteDetailList() {
        return inviteDetailList;
    }

    public void setInviteDetailList(List<InviteDetailEntity> inviteDetailList) {
        this.inviteDetailList = inviteDetailList;
    }
}
