package com.ejianc.business.fjwz.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fjwz.bean.TalkRecordDetailEntity;
/**
 * 洽商谈判-记录主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fjwz_talk_record")
public class TalkRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="talk_id")
    private Long talkId; // 洽商谈判主表主键
    @TableField(value="invite_id")
    private Long inviteId; // 招标立项主键
    @TableField(value="document_id")
    private Long documentId; // 询价公告主键
    @TableField(value="bill_id")
    private Long billId; // 来源单据主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="talk_name")
    private String talkName; // 洽商名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织name
    @TableField(value="parent_org_source_id")
    private String parentOrgSourceId; // 父级组织来源id
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源id
    @TableField(value="talk_start_time")
    private Date talkStartTime; // 洽商开始时间
    @TableField(value="talk_end_time")
    private Date talkEndTime; // 洽商结束时间
    @TableField(value="talk_num")
    private Integer talkNum; // 洽商轮数
    @TableField(value="talk_num_name")
    private String talkNumName; // 洽商轮数名称
    @TableField(value="talk_money")
    private BigDecimal talkMoney; // 洽商参考价
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布,0-是,1-否
    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-是,1-否
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="unit_id")
    private Long unitId; // 询价单位ID
    @TableField(value="unit_source_id")
    private String unitSourceId; // 询价单位来源ID
    @TableField(value="unit_name")
    private String unitName; // 询价单位name
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="talkRecordDetailService",pidName = "recordId")//此处有pid="xxx"，默认值pid="pid"
    private List<TalkRecordDetailEntity> talkRecordDetailList = new ArrayList<>(); // 洽商谈判-截止时间记录备份表
    

    public Long getTalkId() {
        return talkId;
    }

    public void setTalkId(Long talkId) {
        this.talkId = talkId;
    }
    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getTalkName() {
        return talkName;
    }

    public void setTalkName(String talkName) {
        this.talkName = talkName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Date getTalkStartTime() {
        return talkStartTime;
    }

    public void setTalkStartTime(Date talkStartTime) {
        this.talkStartTime = talkStartTime;
    }
    public Date getTalkEndTime() {
        return talkEndTime;
    }

    public void setTalkEndTime(Date talkEndTime) {
        this.talkEndTime = talkEndTime;
    }
    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    public String getTalkNumName() {
        return talkNumName;
    }

    public void setTalkNumName(String talkNumName) {
        this.talkNumName = talkNumName;
    }
    public BigDecimal getTalkMoney() {
        return talkMoney;
    }

    public void setTalkMoney(BigDecimal talkMoney) {
        this.talkMoney = talkMoney;
    }
    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitSourceId() {
        return unitSourceId;
    }

    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
    public List<TalkRecordDetailEntity> getTalkRecordDetailList() {
        return talkRecordDetailList;
    }

    public void setTalkRecordDetailList(List<TalkRecordDetailEntity> talkRecordDetailList) {
        this.talkRecordDetailList = talkRecordDetailList;
    }
}
