package com.ejianc.business.fjwz.controller;

import java.io.Serializable;

import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.impl.PicketageBpmServiceImpl;
import com.ejianc.business.fjwz.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.service.IDocumentService;
import org.springframework.web.multipart.MultipartFile;

/**
 * 询价公告-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("document")
@Api(value = "询价公告-主表", tags = {"询价公告-主表"})
public class DocumentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "cscec5b-document-code";//此处需要根据实际修改

    @Autowired
    private IDocumentService service;
    @Autowired
    private PicketageBpmServiceImpl picketageBpmService;
    @Autowired
    private IInviteService inviteService;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DocumentVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DocumentVO saveOrUpdateVO) {
    	DocumentEntity entity = BeanMapper.map(saveOrUpdateVO, DocumentEntity.class);
    	service.saveOrUpdate(entity, false);
        DocumentVO documentVO = service.queryDetail(entity.getId());
        return CommonResponse.success("保存或修改单据成功！",documentVO);
    }
    @ApiOperation("test")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long billId) {
        picketageBpmService.afterApprovalProcessor(billId, 0, "s");
        return CommonResponse.success("保存或修改单据成功！","s");
    }
    @ApiOperation("询价立项下一步接口")
    @RequestMapping(value = "/saveDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentVO> saveDocument(@RequestParam Long id) {
        DocumentVO documentVO = service.saveDocument(id);
        return CommonResponse.success("保存或修改单据成功！",documentVO);
    }
    @ApiOperation("发布公告接口")
    @RequestMapping(value = "/publishDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentVO> publishDocument(@RequestParam Long id)  {
        return CommonResponse.success("发布成功！",service.publishDocument(id));
    }

    @ApiOperation("供方推送报价信息接口")
    @RequestMapping(value = "/supplierPushSell", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DocumentSupplierVO documentSupplierVO){
        Boolean b = service.supplierPushSell(documentSupplierVO);
        return CommonResponse.success("推送报价信息成功！",b);
    }
    @ApiOperation("根据询价公告主键和供应商主键查询详情接口(单个供应商)")
    @RequestMapping(value = "/getSellInfoById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentSupplierVO> getSellInfoById(@RequestParam Long supplierId,@RequestParam Long documentId) {
        DocumentSupplierVO documentSupplierVO = service.getSellInfoById(supplierId,documentId);
        return CommonResponse.success("查询成功！",documentSupplierVO);
    }
    @ApiOperation("根据询价公告主键和供应商主键查询详情接口(单个供应商 定标使用)")
    @RequestMapping(value = "/getPicSellInfoById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentSupplierVO> getPicSellInfoById(@RequestParam Long inviteId,@RequestParam Long supplierId) {
        DocumentSupplierVO documentSupplierVO = service.getPicSellInfoById(inviteId,supplierId);
        return CommonResponse.success("查询成功！",documentSupplierVO);
    }
    @ApiOperation("洽商谈判供应商方案详情接口(多轮显示)")
    @RequestMapping(value = "/getSupplierTalkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentSupplierVO> getSupplierSchemeTalkDetail(Long supplierDetailId,Long talkId) {
        DocumentSupplierVO documentSupplierVO = service.getSupplierSchemeTalkDetail(supplierDetailId,talkId);
        return CommonResponse.success("查询成功！",documentSupplierVO);
    }

    @ApiOperation("开标接口")
    @RequestMapping(value = "/bidDocument", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentVO> bidDocument(@RequestParam Long id) {
        DocumentVO s = service.bidDocument(id);
        return CommonResponse.success("开标成功！",s);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentVO> queryDetail(@RequestParam Long id) {
        DocumentVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("延长截止时间接口")
    @RequestMapping(value = "/extendDocument", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DocumentVO> extendDocument(@RequestBody DocumentRecordVO documentRecordVO) {
        return CommonResponse.success("延长截止时间！",service.extendDocument(documentRecordVO));
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocumentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DocumentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DocumentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DocumentVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DocumentEntity> page = service.queryPage(param,false);
        IPage<DocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocumentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DocumentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Document-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refDocumentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DocumentVO>> refDocumentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DocumentEntity> page = service.queryPage(param,false);
        IPage<DocumentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocumentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
