package com.ejianc.business.fjwz.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.vo.InviteVO;

/**
 * 询价立项-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invite")
@Api(value = "询价立项-主表", tags = {"询价立项-主表"})
public class InviteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcessService processService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "cscec5b-invite-code";//此处需要根据实际修改
    @Autowired
    private IInviteService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody InviteVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(@RequestParam Long id) {
    	InviteEntity entity = service.selectById(id);
    	InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = service.getAbolishType(tenderId);
        return CommonResponse.success("查询流/废标状态成功！", map);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        service.removeByIds(vos.stream().map(InviteVO::getId).collect(Collectors.toList()),true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId, vos.stream().map(InviteVO::getId).collect(Collectors.toList())));

        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        boolean mobile = param.getParams().containsKey("projectId");
//        if(!mobile){
//            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//            } else {
//                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
//                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            }
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<InviteEntity> page = service.queryPage(param,false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<InviteVO> inviteVOS = BeanMapper.mapList(page.getRecords(), InviteVO.class);
        if(CollectionUtils.isNotEmpty(inviteVOS)){
            for (InviteVO inviteVO : inviteVOS){
                inviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(inviteVO.getTenderStage()).getDescription());
            }
        }
        pageData.setRecords(inviteVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        boolean mobile = param.getParams().containsKey("projectId");
//        if(!mobile){
//            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//            } else {
//                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
//                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            }
//        }
        List<InviteEntity> list = service.queryList(param);

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<InviteVO> inviteVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            inviteVOList = BeanMapper.mapList(list,InviteVO.class);
        }
        for (InviteVO inviteVO : inviteVOList){
            inviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(inviteVO.getTenderStage()).getDescription());
            inviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(inviteVO.getBillState()).getDescription());
        }
        beans.put("records", inviteVOList);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 处理condition */
        JSONObject _con = JSONObject.parseObject(condition);
        if (_con.containsKey("projectId")) {
            Long projectId = Long.parseLong(_con.get("projectId").toString());
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            param.getParams().put("supplierId", new Parameter(QueryParam.SQL, "supplier_id is not null"));
        }

        IPage<InviteEntity> page = service.queryPage(param,false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
