package com.ejianc.business.fjwz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.LossSetEntity;
import com.ejianc.business.fjwz.service.ILossSetService;
import com.ejianc.business.fjwz.vo.LossSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 损耗率设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("lossSet")
@Api(value = "损耗率设置", tags = {"损耗率设置"})
public class LossSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ILossSetService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialApi materialApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LossSetVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody LossSetVO saveOrUpdateVO) {
    	LossSetEntity entity = BeanMapper.map(saveOrUpdateVO, LossSetEntity.class);
        UserContext userContext = sessionManager.getUserContext();
        entity.setEmployeeId(userContext.getEmployeeId());
        entity.setEmployeeName(userContext.getEmployeeName());
        entity.setBillTime(new Date());
    	if (entity.getId() == null) {
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setOrgCode(userContext.getOrgCode());
    	    List<LossSetEntity> list = service.list(new QueryWrapper<LossSetEntity>().eq("material_type_id",entity.getMaterialTypeId()).eq("org_id",entity.getOrgId()));
    	    if (!list.isEmpty()){
    	        throw new BusinessException("分类名称重复!");
            }
            CommonResponse<MaterialCategoryVO> materialCategoryVO = materialApi.queryCategoryById(entity.getMaterialTypeId());
            entity.setCategoryInnerCode(materialCategoryVO.getData().getInnerCode());
            entity.setCategorySourceId(materialCategoryVO.getData().getSourceId());
        }
    	service.saveOrUpdate(entity, false);
    	return CommonResponse.success("保存或修改单据成功！");
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LossSetVO> queryDetail(@RequestParam Long id) {
    	LossSetEntity entity = service.selectById(id);
    	LossSetVO vo = BeanMapper.map(entity, LossSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LossSetVO> vos) {
        service.removeByIds(vos.stream().map(LossSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LossSetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("materialTypeCode","materialTypeName","lossRate","employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        IPage<LossSetEntity> page = service.queryPage(param,false);
        IPage<LossSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LossSetVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 启用停用
     */
    @RequestMapping(value = "/turnSwitch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> turnSwitch(@RequestBody LossSetVO vo) {
        String msg = "";
        LambdaUpdateWrapper<LossSetEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(LossSetEntity::getStatus, vo.getStatus());
        lambd.eq(LossSetEntity::getId, vo.getId());
        service.update(lambd);
        msg = vo.getStatus() == 0?"停用成功！":"启用成功！";
        return CommonResponse.success(msg);
    }

    /**
     * @Description 查询最近启用的损耗率
     * @param vo 物料分类ids
     */
    @RequestMapping(value = "/getLossRate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> getLossRate(@RequestBody LossSetVO vo) {
        Map<Long, BigDecimal> result = new HashMap<>();
        CommonResponse<List<MaterialCategoryVO>> voLists = materialApi.queryCategoryListByChildren(vo.getIds());
        List<Long> vids = new ArrayList<>();
        List<Long> cids;
        Map<Long,MaterialCategoryVO> map;
        Map<Long,List<Long>> vidMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(voLists.getData())){
            map = voLists.getData().stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (k1, k2) -> k2));
            for (Long id : vo.getIds()) {
                cids = Arrays.stream(map.get(id).getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                Collections.reverse(cids);
                vidMap.put(id, cids);
                vids.addAll(cids);
            }
            vids = vids.stream().distinct().collect(Collectors.toList());
        }else {
            throw new BusinessException("物料分类档案未查到当前分类及上级分类！");
        }
        List<LossSetEntity> list = service.list(new QueryWrapper<LossSetEntity>()
                .in("material_type_id",vids).eq("org_id",vo.getOrgId())
                .eq("status",1));
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询成功!",result);
        }
        Map<Long,LossSetEntity> maps = list.stream().collect(Collectors.toMap(LossSetEntity::getMaterialTypeId, Function.identity(), (k1, k2) -> k2));
        for (Long id : vo.getIds()) {
            if (result.containsKey(id)){
                continue;
            }
            cids = vidMap.get(id);
            for (Long cid : cids) {
                if (maps.containsKey(cid)){
                    result.put(id,maps.get(cid).getLossRate());
                    break;
                }
            }
        }
        return CommonResponse.success("查询成功!",result);
    }
}
