package com.ejianc.business.fjwz.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fjwz.bean.InviteDetailEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.*;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.business.fjwz.vo.ProcessVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;


import com.ejianc.business.fjwz.bean.WasteEntity;
import com.ejianc.business.fjwz.vo.WasteVO;

/**
 * 中止询价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("waste")
public class WasteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "WASTE";//此处需要根据实际修改

    @Autowired
    private IWasteService service;

    @Autowired
    private IInviteDetailService inservice;

    @Autowired
    private IInviteService inviteService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WasteVO> saveOrUpdate(@RequestBody WasteVO saveOrUpdateVO) {
    	WasteEntity entity = BeanMapper.map(saveOrUpdateVO, WasteEntity.class);
        service.saveOrUpdate(entity, false);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("中止询价");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setFrontendUrl("waste");
        processService.saveOrUpdate(processEntity);
        service.saveOrUpdate(entity, false);
        //回写询价阶段
        LambdaUpdateWrapper<InviteEntity> updateWrapper = new LambdaUpdateWrapper<>();
    	updateWrapper.eq(InviteEntity::getId,entity.getInviteId());
        updateWrapper.set(InviteEntity::getTenderStage,TenderStageEnum.WASTE.getChangeStateCode());
        updateWrapper.set(InviteEntity::getNextFlag,0);
        inviteService.update(updateWrapper);
        WasteVO vo = BeanMapper.map(entity, WasteVO.class);
        List<InviteDetailEntity> list = inservice.list(new QueryWrapper<InviteDetailEntity>().eq("invite_id",entity.getInviteId()));
        vo.setDetailVOS(BeanMapper.mapList(list, InviteDetailVO.class));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/saveWaste", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteVO> saveWaste(@RequestParam Long inviteId) {
        InviteEntity ientity = inviteService.selectById(inviteId);
        WasteEntity entity = new WasteEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setInviteId(ientity.getId());
        entity.setInviteName(ientity.getTenderName());
        entity.setParentOrgId(ientity.getParentOrgId());
        entity.setParentOrgName(ientity.getParentOrgName());
        entity.setOrgId(ientity.getOrgId());
        entity.setOrgName(ientity.getOrgName());
        entity.setParentOrgSourceId(ientity.getParentOrgSourceId());
        entity.setProjectId(ientity.getProjectId());
        entity.setProjectName(ientity.getProjectName());
        entity.setProjectCode(ientity.getProjectCode());
        entity.setUnitId(ientity.getUnitId());
        entity.setUnitName(ientity.getUnitName());
        entity.setUnitSourceId(ientity.getUnitSourceId());
        UserContext userContext = sessionManager.getUserContext();
        entity.setEmployeeId(userContext.getEmployeeId());
        entity.setEmployeeName(userContext.getEmployeeName());
        entity.setApplyTime(new Date());
        service.saveOrUpdate(entity, false);
        List<InviteDetailEntity> list = inservice.list(new QueryWrapper<InviteDetailEntity>().eq("invite_id",entity.getInviteId()));
        WasteVO vo = BeanMapper.map(entity, WasteVO.class);
        vo.setDetailVOS(BeanMapper.mapList(list, InviteDetailVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteVO> queryDetail(Long id) {
    	WasteEntity entity = service.selectById(id);
        List<InviteDetailEntity> list = inservice.list(new QueryWrapper<InviteDetailEntity>().eq("invite_id",entity.getInviteId()));
    	WasteVO vo = BeanMapper.map(entity, WasteVO.class);
        vo.setDetailVOS(BeanMapper.mapList(list, InviteDetailVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WasteVO> vos) {
        WasteEntity wasteEntity = service.selectById(vos.get(0).getId());
        InviteEntity entity = inviteService.selectById(wasteEntity.getInviteId());
        List<ProcessVO> processVOS = processService.queryProcess(wasteEntity.getInviteId());
        int size = processVOS.size();
        entity.setTenderStage(size-2);
        LambdaUpdateWrapper<ProcessEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProcessEntity::getBillId,wasteEntity.getId());
        updateWrapper.set(ProcessEntity::getDr,1);
        processService.update(updateWrapper);
        inviteService.saveOrUpdate(entity);
        service.removeByIds(vos.stream().map(WasteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

}
