package com.ejianc.business.fjwz.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 公共支持服务
 *
 * @Author:
 * @Version: 1.0
 */
@Service("commonSupportService")
public class CommonSupportService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Autowired
    private IPushMessageApi pushMessageApi;


    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if (redisTemplate.opsForValue().get("X-Open-Token") != null) {
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------" + redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        } else {
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if ("200".equals(json.get("code").toString())) {
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token, 6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                } else {
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }


    public void sendMsg(PushMsgParameter parameter, String url) {
        logger.info("发送消息开始！===========");
        if (Arrays.asList(parameter.getChannel()).contains(PushMsgParameter.CHANNEL_TYPE_WJY)) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", parameter.getSubject());
            wjyMsgParams.put("url", url);
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.info("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

}
