package com.ejianc.business.fjwz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.InviteDetailEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.business.fjwz.vo.InviteSupplierVO;
import com.ejianc.business.fjwz.vo.InviteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.InviteMapper;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.service.IInviteService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.core.kit.mapper.BeanMapper.map;
import static com.ejianc.framework.core.kit.mapper.BeanMapper.mapList;

/**
 * 询价立项-主表
 * 
 * @author generator
 * 
 */
@Service("inviteService")
public class InviteServiceImpl extends BaseServiceImpl<InviteMapper, InviteEntity> implements IInviteService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProcessService processService;
    private static final String BILL_CODE = "cscec5b-invite-code";//此处需要根据实际修改

    @Override
    public InviteVO saveOrUpdate(InviteVO saveOrUpdateVO) {
        //查询项目部上级组织的的来源id
//        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(saveOrUpdateVO.getParentOrgId());
//        if(!orgParentVo.isSuccess()) {
//            throw new BusinessException("网络异常， 查询组织详情失败， 请稍后再试");
//        }
//
//
//        saveOrUpdateVO.setParentOrgSourceId(orgParentVo.getData().getSourceId());
        InviteEntity inviteEntity = BeanMapper.map(saveOrUpdateVO, InviteEntity.class);
        if (inviteEntity.getId() == null || inviteEntity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                inviteEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        inviteEntity.setNextFlag(1);
        inviteEntity.setTenderStage(TenderStageEnum.INVITE.getChangeStateCode());

        //处理物资分类汇总
        List<InviteDetailEntity> inviteDetailList = inviteEntity.getInviteDetailList();
        String materialTypeNames = inviteDetailList.stream().map(InviteDetailEntity::getMaterialTypeName).collect(Collectors.joining(","));
        inviteEntity.setMaterialTypeNames(materialTypeNames);

        super.saveOrUpdate(inviteEntity, false);
        //回写进展表
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(inviteEntity.getId());
            processEntity.setBillName("询价立项");
            processEntity.setTenderId(inviteEntity.getId());
            processEntity.setFrontendUrl("invite/card");
            processService.saveOrUpdate(processEntity);

        }
        InviteVO vo = map(inviteEntity, InviteVO.class);
        return vo;

    }
    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        InviteEntity inviteEntity = super.selectById(tenderId);
        InviteVO vo = BeanMapper.map(inviteEntity, InviteVO.class);
        //0-正常,1-终止
        Integer status = 0;
        if (vo.getTenderStage().equals(TenderStageEnum.WASTE.getChangeStateCode())){
            status = 1;
        }
        map.put("abolishType", status);
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
}
