package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.DocumentEntity;
import com.ejianc.business.fjwz.bean.DocumentSupplierEntity;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.PicketageEntity;
import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.service.IDocumentSupplierService;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IPicketageService;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.GF.UpdateGFVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service("picketage") 
public class PicketageBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPicketageService picketageService;
    @Autowired
    private IDocumentService documentService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
	@Autowired
	private IInviteService inviteService;

	@Value("${openApi.updateTimeOrStateUrl}")
	private String updateTimeOrStateUrl;
	private final Logger logger = LoggerFactory.getLogger(getClass());
	@Value("${wjy.appid}")
	private String appid;

	@Value("${openApi.wjTokenUrl}")
	private String wjTokenUrl;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//查询最大轮数
		PicketageEntity picketageEntity = picketageService.selectById(billId);
		LambdaQueryWrapper<DocumentEntity> lambdaDoc = Wrappers.<DocumentEntity>lambdaQuery();
		lambdaDoc.eq(DocumentEntity::getInviteId, picketageEntity.getInviteId());
		DocumentEntity documentEntity = documentService.getOne(lambdaDoc);

		LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
		lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentEntity.getId());
		List<DocumentSupplierEntity> supplierEntityList = documentSupplierService.list(lambdaSupplier);
		List<Integer> talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
		Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();
		//查询出中标供应商信息
		LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplierBid = Wrappers.<DocumentSupplierEntity>lambdaQuery();
		lambdaSupplierBid.eq(DocumentSupplierEntity::getTalkNum, talkNumMax);
		lambdaSupplierBid.eq(DocumentSupplierEntity::getDocumentId, documentEntity.getId());
		List<DocumentSupplierEntity> supplierEntities = documentSupplierService.list(lambdaSupplier);
		DocumentSupplierEntity documentSupplierEntity = supplierEntities.stream().filter(s -> s.getTenderFlag() == 1).findFirst().get();

		//回写询价立项中标供应商
		InviteEntity inviteEntity = inviteService.selectById(documentEntity.getInviteId());
		inviteEntity.setSupplierSourceId(documentSupplierEntity.getSupplierSourceId());
		inviteEntity.setSupplierId(documentSupplierEntity.getSupplierId());
		inviteEntity.setSupplierName(documentSupplierEntity.getSupplierName());
		inviteService.updateById(inviteEntity);
		pushSupplier(picketageEntity, documentSupplierEntity);


		return CommonResponse.success();
	}

	private void pushSupplier(PicketageEntity picketageEntity, DocumentSupplierEntity documentSupplierEntity) {
		//回写供方
		UpdateGFVO updateGFVO = new UpdateGFVO();
		updateGFVO.setType(3);
		updateGFVO.setSourceId(Long.toString(picketageEntity.getInviteId()));
		updateGFVO.setPkSupplier(documentSupplierEntity.getSupplierSourceId());
		updateGFVO.setSupplierName(documentSupplierEntity.getSupplierName());
		updateGFVO.setSupplierSourceId(documentSupplierEntity.getSupplierId());
		updateGFVO.setBillDate(picketageEntity.getPicketageTime());
		updateGFVO.setPkCreator("hnxpt");
		updateGFVO.setSysmark("hnxpt");
		updateGFVO.setCreatorName("五局新平台");
		String pattern = "yyyy-MM-dd HH:mm:ss";
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
		updateGFVO.setCreatorDate(simpleDateFormat.format(new Date()));
		//推送供应商
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = documentService.getAccessToken(headers);
		String back = null;
		try {
			logger.info("---url:" + updateTimeOrStateUrl);
			logger.info("---定标回写入参:" + JSONObject.toJSON(updateGFVO).toString());
			logger.info("---headers:" + JSONObject.toJSON(headers).toString());
			back = HttpTookit.postByJson(updateTimeOrStateUrl, JSONObject.toJSON(updateGFVO).toString(), headers);
			JSONObject jsonBack = JSONObject.parseObject(back);
			logger.info("---回参:" + jsonBack);
			if("200".equals(jsonBack.getString("code"))){
			}else{
//                调用同步方法失败，输出错误信息
				throw new BusinessException(jsonBack.getString("msg"));
			}
		} catch (Exception e) {
			logger.info(e.getMessage());
			throw new BusinessException("推送供方公告信息失败");
		}
	}

//	private CommonResponse<String> getAccessToken(Map<String, String> headers) {
//		//获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
//		logger.info("------------  开始获取token  ------------");
//		Set<String> keys = redisTemplate.keys("X-Open-Token");
//		if (CollectionUtils.isNotEmpty(keys)) {
//			redisTemplate.delete(keys);
//		}
//
//		if(redisTemplate.opsForValue().get("X-Open-Token") != null){
//			//若存在，直接放到header中
//			logger.info("------------  redisTemplate里有token  ------------"+redisTemplate.opsForValue().get("X-Open-Token"));
//			headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
//		}else{
//			String initContextUrl = wjTokenUrl;
//			String responseStr = null;
//			try {
//				responseStr = HttpTookit.get(initContextUrl, null);
//				JSONObject json = JSONObject.parseObject(responseStr);
//				if("200".equals(json.get("code").toString())){
//					JSONObject data = json.getJSONObject("body");
//					String access_token = data.get("token").toString();
//					headers.put("X-Open-Token", access_token);
//					//将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
//					redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
//					logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
//				}else{
//					//请求失败，输出错误信息
//					return CommonResponse.error("系统推送供方时，获取供方access_token异常");
//				}
//			} catch (GeneralSecurityException e) {
//				logger.info("GeneralSecurityException 异常"+e.getMessage());
//				return CommonResponse.error("系统推送供方时，获取供方access_token异常");
//			} catch (IOException e) {
//				logger.info("IOException 异常"+e.getMessage());
//				return CommonResponse.error("系统推送供方时，获取供方access_token异常");
//			}
//		}
//		return CommonResponse.success();
//	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
