package com.ejianc.business.fjwz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.*;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.*;
import com.ejianc.business.fjwz.vo.DocumentSupplierVO;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.PicketageVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.PicketageMapper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 定标-主表
 * 
 * @author generator
 * 
 */
@Service("picketageService")
public class PicketageServiceImpl extends BaseServiceImpl<PicketageMapper, PicketageEntity> implements IPicketageService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    @Autowired
    private ITalkRecordService talkRecordService;
    @Autowired
    private ITalkService talkService;
    @Autowired
    private ITalkRecordDetailService talkRecordDetailService;
    @Autowired
    private IDocumentService documentService;
    @Autowired
    private ITalkDetailService talkDetailService;
    private static final String BILL_CODE = "cscec5b-picketage-code";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;


    @Override
    public PicketageVO savePicketage(Long billId,Integer type) {
        PicketageEntity entity = new PicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //转换数据,type 0-询价公告,1-洽商谈判
        Long documentId = null;
        if (type == 0) {
            //更新洽商谈判状态
            documentId = billId;
        }
        if (type == 1) {
            TalkEntity talkEntity = talkService.selectById(billId);
            talkEntity.setNextFlag(0);
            talkService.updateById(talkEntity);

            documentId = talkEntity.getDocumentId();
        }
        DocumentEntity documentEntity = documentService.selectById(documentId);
        if (type == 0) {
            documentEntity.setNextFlag(0);
            documentService.updateById(documentEntity);
        }
        InviteEntity inviteEntity = inviteService.selectById(documentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(documentEntity.getEmployeeId());
        entity.setEmployeeName(documentEntity.getEmployeeName());
        entity.setDoucumentLinkMobile(documentEntity.getEmployeeMobile());
        entity.setDoucumentLinkId(documentEntity.getDoucumentLinkId());
        entity.setDoucumentLinkName(documentEntity.getDoucumentLinkName());
        entity.setBillId(billId);
        entity.setInviteId(inviteEntity.getId());
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setProjectSourceId(inviteEntity.getProjectSourceId());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgSourceId(inviteEntity.getParentOrgSourceId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setUnitName(inviteEntity.getUnitName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitSourceId(inviteEntity.getUnitSourceId());
        super.saveOrUpdate(entity, false);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.PICKETAGE.getChangeStateCode());

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("询价结果");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setFrontendUrl("invite/picketageCard");
        processService.saveOrUpdate(processEntity);

        //更新默认第一中标供应商数据

        //查询最大轮数
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentId);
        List<DocumentSupplierEntity> supplierEntityList = documentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();

        //默认第一名中标
        DocumentVO documentVO = documentService.queryDocDetail(documentId, talkNumMax);
        List<DocumentSupplierVO> documentSupplierList = documentVO.getDocumentSupplierList();
        List<DocumentSupplierVO> sortList = documentSupplierList.stream().sorted(Comparator.comparing(DocumentSupplierVO::getMoneyTax).reversed())
                .collect(Collectors.toList());
        DocumentSupplierVO documentSupplierVO = sortList.get(0);
        documentSupplierVO.setTenderFlag(1);
        DocumentSupplierEntity documentSupplierEntity = BeanMapper.map(documentSupplierVO, DocumentSupplierEntity.class);
        documentSupplierService.updateById(documentSupplierEntity);

        //更新询价立项表
        inviteEntity.setSupplierId(documentSupplierVO.getSupplierId());
        inviteEntity.setSupplierName(documentSupplierVO.getSupplierName());
        inviteEntity.setSupplierSourceId(documentSupplierVO.getSupplierSourceId());
        inviteService.updateById(inviteEntity);


        //更新中标供应商报价数据
        LambdaQueryWrapper<DocumentSellEntity> lambdaSell = Wrappers.<DocumentSellEntity>lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getDocumentId, documentEntity.getId());
        lambdaSell.eq(DocumentSellEntity::getTalkNum, talkNumMax);
        List<DocumentSellEntity> sellTalkMaxList = documentSellService.list(lambdaSell);
        for (DocumentSellEntity documentSellEntity : sellTalkMaxList){
            if (documentSellEntity.getSupplierId().equals(documentSupplierEntity.getSupplierId())){
                documentSellEntity.setBidFlag(1);
            }else {
                documentSellEntity.setBidFlag(0);
            }

        }
        documentSellService.updateBatchById(sellTalkMaxList);

        return queryDetail(entity.getId());
    }

    @Override
    public PicketageVO queryDetail(Long id) {
        PicketageEntity picketageEntity = super.selectById(id);
        PicketageVO picketageVO = BeanMapper.map(picketageEntity, PicketageVO.class);
        //查询最大轮数

        LambdaQueryWrapper<DocumentEntity> lambdaDoc = Wrappers.<DocumentEntity>lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, picketageEntity.getInviteId());
        DocumentEntity documentEntity = documentService.getOne(lambdaDoc);
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentEntity.getId());
        List<DocumentSupplierEntity> supplierEntityList = documentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();

//        DocumentEntity entity = documentService.selectById(documentEntity.getId());
//        DocumentVO stuffDocumentVO = BeanMapper.map(entity, DocumentVO.class);
        //默认第一名中标
        DocumentVO documentVO = documentService.queryDocDetail(documentEntity.getId(), talkNumMax);
        List<DocumentSupplierVO> documentSupplierList = documentVO.getDocumentSupplierList();
        List<DocumentSupplierVO> supplierVOS = documentSupplierList.stream().filter(s -> s.getTenderFlag().equals(1)).collect(Collectors.toList());
        List<DocumentSupplierVO> sortList = documentSupplierList.stream().sorted(Comparator.comparing(DocumentSupplierVO::getMoneyTax).reversed())
                .collect(Collectors.toList());
        //设置排名
        Integer rank = 1;
        for(DocumentSupplierVO documentSupplierVO : sortList){
            documentSupplierVO.setRank(rank);
            rank++;
        }


        picketageVO.setSupplierList(sortList);
        DocumentSupplierVO documentSupplierVO = supplierVOS.get(0);
        List<DocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
        documentSupplierVOS.add(documentSupplierVO);
        picketageVO.setSupplierBidList(documentSupplierVOS);

        return picketageVO;
    }

    @Override
    public PicketageVO saveOrUpdate(PicketageVO saveOrUpdateVO) {
        PicketageEntity entity = BeanMapper.map(saveOrUpdateVO, PicketageEntity.class);
        LambdaQueryWrapper<DocumentEntity> lambdaDoc = Wrappers.<DocumentEntity>lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, saveOrUpdateVO.getInviteId());
        DocumentEntity documentEntity = documentService.getOne(lambdaDoc);
        super.saveOrUpdate(entity,false);
        List<DocumentSupplierVO> supplierBidList = saveOrUpdateVO.getSupplierBidList();
        if (CollectionUtils.isNotEmpty(supplierBidList)){
            DocumentSupplierVO documentSupplierBidVO = supplierBidList.get(0);
            //查询最大轮数
            LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
            lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentEntity.getId());
            List<DocumentSupplierEntity> supplierEntityList = documentSupplierService.list(lambdaSupplier);
            List<Integer> talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
            Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();
            //更新中标供应商
            List<DocumentSupplierEntity> supplierEntities = supplierEntityList.stream().filter(s -> s.getTalkNum().equals(talkNumMax)).collect(Collectors.toList());
            DocumentSupplierEntity documentSupplierBidEntity = supplierEntities.stream().findFirst().get();
            for (DocumentSupplierEntity documentSupplierEntity : supplierEntities){
                if (documentSupplierEntity.getSupplierId().equals(documentSupplierBidVO.getSupplierId())){
                    documentSupplierBidEntity.setTenderFlag(1);
                }else {
                    documentSupplierBidEntity.setTenderFlag(0);

                }
            }
            documentSupplierService.updateBatchById(supplierEntities);

            //更新中标供应商报价数据
            LambdaQueryWrapper<DocumentSellEntity> lambdaSell = Wrappers.<DocumentSellEntity>lambdaQuery();
            lambdaSell.eq(DocumentSellEntity::getDocumentId, documentEntity.getId());
            lambdaSell.eq(DocumentSellEntity::getTalkNum, talkNumMax);
            List<DocumentSellEntity> sellTalkMaxList = documentSellService.list(lambdaSell);
            for (DocumentSellEntity documentSellEntity : sellTalkMaxList){
                if (documentSellEntity.getSupplierId().equals(documentSupplierBidVO.getSupplierId())){
                    documentSellEntity.setBidFlag(1);
                }else {
                    documentSellEntity.setBidFlag(0);
                }

            }
            documentSellService.updateBatchById(sellTalkMaxList);
        }



        return queryDetail(entity.getId());
    }
}
