package com.ejianc.business.fjwz.util;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface DealWJImageMapper extends BaseCrudMapper<Check> {

    /**
     * 需保证五局数据el_cloud_wj中pca_check与生成的ejc_wzxt_check数据一一对应
     * @return
     */
    @Select("select wc.id, sceneurl, tpurl from pca_check left join ejc_wzxt_check wc on wc.history_id = pca_check.pk_check")
    @MapKey("id")
    Map<Long, Check> getCheckMap();


    /**
     * 将生成的数据转储到五局正式环境
     * @param list
     * @return
     */
    @Insert( "<script> INSERT INTO  ejc_attachment(id, source_id, file_name, file_path, file_size, bill_type, source_type, " +
            "online_path, upload_user_name, sync_es_flag, tenant_id, dr, create_user_code, create_time, version, file_format_path) " +
            "values <foreach collection = 'list' item='record' separator=',' > " +
            "(#{record.id}, #{record.sourceId}, #{record.fileName}, #{record.filePath}, #{record.fileSize}, " +
            "#{record.billType}, #{record.sourceType}, #{record.onlinePath}, #{record.uploadUserName}, " +
            "0, #{record.tenantId}, 0, #{record.createUserCode}, #{record.createTime}, 1, " +
            "#{record.fileFormatPathStr}) </foreach> </script>" )
    int insertAttachmentVO(List<AttachmentVO> list);
}
