package com.ejianc.business.fjwz.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 损耗率设置
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fjwz_loss_set")
public class LossSetEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="org_id")
    private Long orgId; // 所属单位主键
    @TableField(value="org_name")
    private String orgName; // 所属单位名称
    @TableField(value="org_code")
    private String orgCode; // 所属单位编码
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="bill_time")
    private Date billTime; // 编制时间
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_source_id")
    private String parentOrgSourceId; // 上级组织来源id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织name
    @TableField(value="latest_flag")
    private Integer latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Integer enableState; // 是否生效
    @TableField(value="last_duty_id")
    private Long lastDutyId; // 上一版本主键
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="before_duty_version")
    private Integer beforeDutyVersion; // 历史版本号
    @TableField(value="duty_version")
    private Integer dutyVersion; // 版本
    @TableField(value="common_id")
    private Long commonId; // 变更公用id
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效时间
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="lossSetDetailService",pidName = "lossId")
    private List<LossSetDetailEntity> lossSetDetailList = new ArrayList<>(); // 损耗率设置明细
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Integer latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getCommonId() {
        return commonId;
    }

    public void setCommonId(Long commonId) {
        this.commonId = commonId;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    

    public List<LossSetDetailEntity> getLossSetDetailList() {
        return lossSetDetailList;
    }

    public void setLossSetDetailList(List<LossSetDetailEntity> lossSetDetailList) {
        this.lossSetDetailList = lossSetDetailList;
    }
}
