package com.ejianc.business.fjwz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.InviteEntity;
import com.ejianc.business.fjwz.bean.ProcessEntity;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.IProcessService;
import com.ejianc.business.fjwz.vo.AnalysisVO;
import com.ejianc.business.fjwz.vo.InviteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 询价立项-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("analysis")
@Api(value = "废旧物资处置分析", tags = {"废旧物资处置分析"})
public class AnalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IInviteService service;

    /**
     * 表头数据
     * @return
     */
    @RequestMapping(value = "/getNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AnalysisVO> getNum() {
        AnalysisVO analysisVO = service.getNum();
        return  CommonResponse.success("查询成功！",analysisVO);
    }

    /**
     * 处置金额期间对比分析
     * @return
     */
    @RequestMapping(value = "/getPeriodMoney", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodMoney() {
        List<AnalysisVO> list = service.getPeriodMoney();
        return  CommonResponse.success("查询成功！",list);
    }
    /**
     * 处置申请次数期间对比分析
     * @return
     */
    @RequestMapping(value = "/getPeriodCs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodCs() {
        List<AnalysisVO> list = service.getPeriodCs();
        return  CommonResponse.success("查询成功！",list);
    }
    /**
     * 获取下级单位使用情况接口
     * @return
     */
    @RequestMapping(value = "/getUseInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getUseInfo() {
        List<AnalysisVO> list = service.getUseInfo(InvocationInfoProxy.getOrgId());
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 获取下级单位使用情况接口
     * @return
     */
    @RequestMapping(value = "/getUseInfoByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getUseInfoByOrgId(Long orgId) {
        List<AnalysisVO> list = service.getUseInfo(orgId);
        return  CommonResponse.success("查询成功！",list);
    }

}
