package com.ejianc.business.fjwz.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fjwz.bean.DisposeDetailEntity;
import com.ejianc.business.fjwz.mapper.InviteDetailMapper;
import com.ejianc.business.fjwz.mapper.ScarpDetailMapper;
import com.ejianc.business.fjwz.service.IDisposeDetailService;
import com.ejianc.business.fjwz.util.PageUtil;
import com.ejianc.business.fjwz.vo.DisposeDetailVO;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import com.ejianc.business.fjwz.vo.ScarpDetailVO;
import com.ejianc.business.wzxt.api.ICheckApi;
import com.ejianc.business.wzxt.vo.MaterialInRefVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fjwz.bean.DisposeEntity;
import com.ejianc.business.fjwz.service.IDisposeService;
import com.ejianc.business.fjwz.vo.DisposeVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 处置申请
 *
 * @author generator
 */
@Controller
@RequestMapping("dispose")
public class DisposeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DISPOSE";//此处需要根据实际修改

    @Autowired
    private IDisposeService service;


    @Autowired
    private IDisposeDetailService detailService;

    @Autowired
    private InviteDetailMapper inviteMapper;

    @Autowired
    private ScarpDetailMapper scarpDetailMapper;

    @Autowired
    private ICheckApi checkApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DisposeVO> saveOrUpdate(@RequestBody DisposeVO saveOrUpdateVO) {
        DisposeEntity entity = BeanMapper.map(saveOrUpdateVO, DisposeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        for (DisposeDetailEntity detailEntity : entity.getDisposeDetailList()) {
            if(null == detailEntity.getMaterialId()){
                detailEntity.setMaterialId(IdWorker.getId());
            }
        }
        service.saveOrUpdate(entity, false);
        DisposeVO vo = BeanMapper.map(entity, DisposeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DisposeVO> queryDetail(Long id) {
        DisposeEntity entity = service.selectById(id);
        DisposeVO vo = BeanMapper.map(entity, DisposeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisposeVO> vos) {
//        if(ListUtil.isNotEmpty(vos)){
//            for (DisposeVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
        service.removeByIds(vos.stream().map(DisposeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "materialTypeNames"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<DisposeEntity> page = service.queryPage(param, false);
        IPage<DisposeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DisposeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "materialTypeNames"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if (!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<DisposeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<DisposeVO> voList = BeanMapper.mapList(list, DisposeVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("Dispose-export.xlsx", beans, response);
    }

    /**
     * @param orgId
     * @Description queryParentOrg 查询上级组织
     */
    @RequestMapping(value = "/queryParentOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(iOrgApi.detailById(orgId).getData().getParentId());
        return CommonResponse.success(orgVO.getData());
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDisposeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DisposeDetailVO>> refDisposeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<DisposeDetailVO> list = detailService.getMaterialDetail(wrapper);
        List<Long> materialListId = list.stream().map(DisposeDetailVO::getId).collect(Collectors.toList());
        List<DisposeDetailVO> refList = new ArrayList<>();
        if (!materialListId.isEmpty()) {
            String ids = StringUtils.join(materialListId, ",");

            //取询价立项的数量
            List<InviteDetailVO> dList = inviteMapper.getByMaterialId(ids, wrapper);
            Map<Long, InviteDetailVO> maps = dList.stream().collect(Collectors.toMap(InviteDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
            //取出场类型为参照处置申请的数量
            List<ScarpDetailVO> scarpDetailVOS = scarpDetailMapper.getByMaterialId(ids, wrapper);
            Map<Long, ScarpDetailVO> scarpMap = scarpDetailVOS.stream().collect(Collectors.toMap(ScarpDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));

            for (DisposeDetailVO detailVO : list) {
                //两种数据合并，作为占用数量
                InviteDetailVO inviteDetailVO = maps.containsKey(detailVO.getMaterialId()) ? maps.get(detailVO.getMaterialId()) : new InviteDetailVO();
                ScarpDetailVO scarpDetailVO = scarpMap.containsKey(detailVO.getMaterialId()) ? scarpMap.get(detailVO.getMaterialId()) : new ScarpDetailVO();
                detailVO.setSurplusNum(ComputeUtil.safeSub(detailVO.getSumNum(), ComputeUtil.safeAdd(inviteDetailVO.getTenderNum(), scarpDetailVO.getNum())));
                if (detailVO.getSurplusNum().compareTo(BigDecimal.ZERO) > 0) {
                    refList.add(detailVO);
                }
            }
        }
        IPage<DisposeDetailVO> pageData = new Page<>();
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        pageData.setTotal(refList.size());
        refList = PageUtil.listToPage(refList, pageNumber, pageSize);
        pageData.setRecords(refList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 在场材料参照
     * @Return void
     */
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DisposeDetailVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        CommonResponse<List<MaterialInRefVO>> checkData =  checkApi.queryInMaterial(projectId);
        if (!checkData.isSuccess()){
            throw new BusinessException(checkData.getMsg());
        }
        List<MaterialInRefVO> checkList = checkData.getData();//累计进场
        List<Long> materialListId = checkList.stream().map(MaterialInRefVO::getMaterialId).collect(Collectors.toList());
        if (StringUtils.isNotBlank(searchText)){
            checkList = checkList.stream()
                    .filter(p -> p.getMaterialName().contains(searchText)
                            || p.getMaterialCode().contains(searchText) )
                    .collect(Collectors.toList());
        }
        List<DisposeDetailVO> checkVos = BeanMapper.mapList(checkList,DisposeDetailVO.class);
        Map<Long,DisposeDetailVO> checkMap = checkVos.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        List<DisposeDetailVO> list = new ArrayList<>();
        if (!materialListId.isEmpty()) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            String ids = StringUtils.join(materialListId, ",");
            list = detailService.getDisposeDetail(ids, wrapper);//查询处置申请
        }
        Map<Long, DisposeDetailVO> maps = list.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        List<DisposeDetailVO> refList = new ArrayList<>();
        DisposeDetailVO ref;
        for (MaterialInRefVO detailVO : checkList) {
            ref = checkMap.get(detailVO.getMaterialId());
            ref.setId(detailVO.getMaterialId());
            ref.setSumNum(detailVO.getRentNum());
            ref.setSumMny(detailVO.getRentMny());
            ref.setSumTaxMny(detailVO.getRentTaxMny());
            ref.setUnitName(detailVO.getUnit());
            if (!maps.containsKey(detailVO.getMaterialId())) {
                ref.setSurplusNum(detailVO.getRentNum());//剩余可申请数量
                ref.setSumLossRate(BigDecimal.ZERO);
                ref.setSumLossNum(BigDecimal.ZERO);
                refList.add(ref);
                continue;
            }
            ref.setSurplusNum(ComputeUtil.safeSub(detailVO.getRentNum(), maps.get(detailVO.getMaterialId()).getSumNum()));//剩余可申请数量
            ref.setSumLossRate(maps.get(detailVO.getMaterialId()).getSumLossRate());//总损耗率
            ref.setSumLossNum(maps.get(detailVO.getMaterialId()).getSumNum());
            if (ref.getSurplusNum().compareTo(BigDecimal.ZERO) > 0) {
                refList.add(ref);
            }
        }
        IPage<DisposeDetailVO> pageData = new Page<>();
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        pageData.setTotal(refList.size());
        refList = PageUtil.listToPage(refList, pageNumber, pageSize);
        pageData.setRecords(refList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param vo
     * @Description queryCheckNum 查询在场材料
     */
    @RequestMapping(value = "/queryCheckNum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, DisposeDetailVO>> queryCheckNum(@RequestBody DisposeDetailVO vo) {
        //累计进场
        Map<Long, DisposeDetailVO> maps = new HashMap<>();
        CommonResponse<List<MaterialInRefVO>> checkData =  checkApi.queryInMaterial(vo.getId());
        if (!checkData.isSuccess()){
            throw new BusinessException(checkData.getMsg());
        }
        List<MaterialInRefVO> checkList = checkData.getData();
        List<DisposeDetailVO> checkVos = BeanMapper.mapList(checkList,DisposeDetailVO.class);
        Map<Long, DisposeDetailVO> checkMap = checkVos.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        DisposeDetailVO dvo;
        for (MaterialInRefVO refVO : checkList) {
            dvo = checkMap.get(refVO.getMaterialId());
            dvo.setId(refVO.getMaterialId());
            dvo.setSumNum(refVO.getRentNum());
            dvo.setSumMny(refVO.getRentMny());
            dvo.setSumTaxMny(refVO.getRentTaxMny());
            dvo.setUnitName(refVO.getUnit());
        }
        String ids = StringUtils.join(vo.getIds(), ",");
        if (checkList.isEmpty()) {
            return CommonResponse.success(maps);
        }
        List<DisposeDetailVO> list = detailService.getDisposeDetails(ids,vo.getId());//查询处置申请
        Map<Long, DisposeDetailVO> map = list.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        for (Long id : vo.getIds()) {
            if (!checkMap.containsKey(id)) {
               maps.put(id, map.get(id));
               continue;
            }
            dvo = checkMap.get(id);
            if (map.containsKey(id)) {
                dvo.setSurplusNum(ComputeUtil.safeSub(dvo.getSumNum(), map.get(id).getSumLossNum()));//剩余可申请数量
                dvo.setSumLossRate(map.get(id).getSumLossRate());//总损耗率
                dvo.setSumLossNum(map.get(id).getSumLossNum());
            }else {
                dvo.setSurplusNum(dvo.getSumNum());//剩余可申请数量
                dvo.setSumLossRate(BigDecimal.ZERO);//总损耗率
                dvo.setSumLossNum(BigDecimal.ZERO);
            }
            maps.put(id, dvo);
        }
        return CommonResponse.success(maps);
    }
}
