package com.ejianc.business.fjwz.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.fjwz.bean.PicketageEntity;
import com.ejianc.business.fjwz.service.IInviteService;
import com.ejianc.business.fjwz.service.ILossSetService;
import com.ejianc.business.fjwz.service.IPicketageService;
import com.ejianc.business.fjwz.vo.LossSetVO;
import com.ejianc.business.fjwz.vo.RecordVO;
import com.ejianc.business.wzxt.api.ICheckApi;
import com.ejianc.business.wzxt.vo.MaterialInRefVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.fjwz.bean.DocumentSellEntity;
import com.ejianc.business.fjwz.service.IDocumentSellService;
import com.ejianc.business.fjwz.vo.DocumentSellVO;

/**
 * 询价公告-报价表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("documentSell")
@Api(value = "询价公告-报价表", tags = {"询价公告-报价表"})
public class DocumentSellController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICheckApi checkApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDocumentSellService service;
    @Autowired
    private IPicketageService picketageService;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private ILossSetService lossSetService;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DocumentSellVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DocumentSellVO saveOrUpdateVO) {
    	DocumentSellEntity entity = BeanMapper.map(saveOrUpdateVO, DocumentSellEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DocumentSellVO vo = BeanMapper.map(entity, DocumentSellVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocumentSellVO> queryDetail(@RequestParam Long id) {
    	DocumentSellEntity entity = service.selectById(id);
    	DocumentSellVO vo = BeanMapper.map(entity, DocumentSellVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DocumentSellVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DocumentSellVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DocumentSellVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DocumentSellVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DocumentSellEntity> page = service.queryPage(param,false);
        IPage<DocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocumentSellVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DocumentSellEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DocumentSell-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refDocumentSellData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DocumentSellVO>> refDocumentSellData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DocumentSellEntity> page = service.queryPage(param,false);
        IPage<DocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DocumentSellVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 项目采购台账
     * @param queryParam
     * @Return
     */
    @RequestMapping(value = "/queryRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<RecordVO>> queryRecord(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long materialTypeId = null;
        String[] materialId = null;
        Long projectId = null;
        Long orgId = null;
        List<Long> materialCategoryVOS = new ArrayList<>();
        if (queryParam.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(String.valueOf(queryParam.getParams().get("projectId").getValue()));
        }
        CommonResponse<List<MaterialInRefVO>> checkData =  checkApi.queryInMaterial(projectId);
        if (!checkData.isSuccess()){
            throw new BusinessException(checkData.getMsg());
        }
        List<MaterialInRefVO> checkList = checkData.getData();
        Map<Long, MaterialInRefVO> checkMap = new HashMap<>();
        for (MaterialInRefVO vo : checkList) {
            if (!checkMap.containsKey(vo.getMaterialId())) {
                checkMap.put(vo.getMaterialId(), vo);
            } else {
                checkMap.get(vo.getMaterialId()).setRentNum(ComputeUtil.safeAdd(checkMap.get(vo.getMaterialId()).getRentNum(), vo.getRentNum()));
            }
        }
        if (queryParam.getParams().containsKey("materialTypeId")) {
            materialTypeId = Long.valueOf(String.valueOf(queryParam.getParams().get("materialTypeId").getValue()));
            queryParam.getParams().remove("materialTypeId");
        }
        if (queryParam.getParams().containsKey("materialId")) {
            materialId = (String.valueOf(queryParam.getParams().get("materialId").getValue())).split(",");
            queryParam.getParams().remove("materialId");
        }
        IPage<PicketageEntity> page = picketageService.queryPage(queryParam, false);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return CommonResponse.error("该项目下没有处置记录！");
        }
        List<Long> inviteIds = new ArrayList<>();
        for (PicketageEntity picketageEntity : page.getRecords()) {
            if (!inviteIds.contains(picketageEntity.getInviteId())) {
                inviteIds.add(picketageEntity.getInviteId());
            }
            orgId = picketageEntity.getOrgId();
        }
        List<DocumentSellEntity> documentSellEntities = service.list(new QueryWrapper<DocumentSellEntity>()
                .in("invite_id", inviteIds)
                .eq("bid_flag", 1)
                .eq(materialTypeId != null, "material_type_id", materialTypeId)
                .in(materialId != null, "material_id", materialId));
        Map<Long, RecordVO> map = new HashMap<>();
        for (DocumentSellEntity entity : documentSellEntities) {
            if (!map.containsKey(entity.getMaterialId())) {
                RecordVO recordVO = new RecordVO();
                recordVO.setDocumentSellId(entity.getId());
                recordVO.setMaterialId(entity.getMaterialId());
                recordVO.setMaterialCode(entity.getMaterialCode());
                recordVO.setMaterialName(entity.getMaterialName());
                recordVO.setMaterialTypeId(entity.getMaterialTypeId());
                materialCategoryVOS.add(entity.getMaterialTypeId());
                recordVO.setMaterialTypeName(entity.getMaterialTypeName());
                recordVO.setSpec(entity.getSpec());
                recordVO.setUnit(entity.getUnit());
                recordVO.setTotalNum(entity.getTenderNum()); //累计处置数量
                recordVO.setMny(entity.getSellMoneyTax()); //处置金额
                if (checkMap.containsKey(entity.getMaterialId())){
                    recordVO.setRentNumber(checkMap.get(entity.getMaterialId()).getRentNum());
                }
                map.put(entity.getMaterialId(), recordVO);
            }else {
                map.get(entity.getMaterialId()).setTotalNum(ComputeUtil.safeAdd(map.get(entity.getMaterialId()).getTotalNum(), entity.getTenderNum()));
                map.get(entity.getMaterialId()).setMny(ComputeUtil.safeAdd(map.get(entity.getMaterialId()).getMny(), entity.getSellMoneyTax()));
            }
        }
        LossSetVO lossSetVO = new LossSetVO();
        lossSetVO.setIds(materialCategoryVOS);
        lossSetVO.setOrgId(orgId);
        Map<Long, BigDecimal> result = lossSetService.getLossRate(lossSetVO);
        List<RecordVO> list = new ArrayList<>();
        for (RecordVO recordVO : map.values()) {
            recordVO.setId(IdWorker.getId());
            if (result != null && result.containsKey(recordVO.getMaterialTypeId())) {
                recordVO.setEarlyLossRate(result.get(recordVO.getMaterialTypeId()));
            }else{
                recordVO.setEarlyLossRate(BigDecimal.ZERO);
            }
            recordVO.setSumLossRate(ComputeUtil.safeDiv(recordVO.getTotalNum(),recordVO.getRentNumber()).setScale(2, BigDecimal.ROUND_HALF_UP));
            list.add(recordVO);
        }
        return CommonResponse.success("查询列表数据成功！",list);
    }

    @ApiOperation("处置记录导出")
    @RequestMapping(value = "/recordExport", method = RequestMethod.POST)
    @ResponseBody
    public void recordExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<List<RecordVO>> list = queryRecord(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Record-export.xlsx", beans, response);
    }
}
