package com.ejianc.business.fjwz.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.fjwz.enums.ChangeStateEnum;
import com.ejianc.business.fjwz.vo.LossSetVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.fjwz.bean.LossSetEntity;
import com.ejianc.business.fjwz.service.ILossSetService;

/**
 * 损耗率设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("lossSet")
@Api(value = "损耗率设置", tags = {"损耗率设置"})
public class LossSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LOSSSET";//此处需要根据实际修改

    @Autowired
    private ILossSetService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialApi materialApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LossSetVO> saveOrUpdate(@RequestBody LossSetVO saveOrUpdateVO) {
    	LossSetEntity entity = BeanMapper.map(saveOrUpdateVO, LossSetEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            entity.setLatestFlag(1);//新增时默认最新版本
            entity.setEnableState(0);//新增时默认不生效
            entity.setChangeState(ChangeStateEnum.未变更.getCode());
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //新增默认版本为1(修订的存在版本号)
        entity.setDutyVersion(entity.getDutyVersion()!=null?entity.getDutyVersion():1);
        entity.setCommonId(entity.getCommonId()!=null?entity.getCommonId():IdWorker.getId());
    	service.saveOrUpdate(entity, false);
    	LossSetVO vo = BeanMapper.map(entity, LossSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description changeTask
     * @param id
     */
    @RequestMapping(value = "/changeTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LossSetVO> changeTask(Long id) {
        LossSetVO vo = service.changeTask(id);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LossSetVO> queryDetail(Long id) {
    	LossSetEntity entity = service.selectById(id);
    	LossSetVO vo = BeanMapper.map(entity, LossSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryReviseDetail 查询历史详情
     * @param id
     */
    @RequestMapping(value = "/queryListById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<LossSetVO>> queryListById(Long id) {
        List<LossSetVO> listById = service.queryListById(id);
        return CommonResponse.success("查询详情数据成功！", listById);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LossSetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LossSetVO vo : vos) {
                LossSetEntity entity = service.getById(vo.getId());
                if(entity.getLastDutyId()!=null){
                    LossSetEntity revise = service.getById(entity.getLastDutyId());
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.未变更.getCode());
                    revise.setLatestFlag(1);
                    service.saveOrUpdate(revise);
                }
            }
        }
        service.removeByIds(vos.stream().map(LossSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LossSetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","projectName","employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        condition(param);
        IPage<LossSetEntity> page = service.queryPage(param,false);
        IPage<LossSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LossSetVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","projectName","employeeName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        condition(param);
        List<LossSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<LossSetVO> lossVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            lossVOList = BeanMapper.mapList(list,LossSetVO.class);
        }
        for (LossSetVO vo : lossVOList){
            vo.setChangeStateName(vo.getChangeState()==0?"未变更":vo.getChangeState()==1?"变更中":"已变更");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        beans.put("records", lossVOList);
        ExcelExport.getInstance().export("LossSet-export.xlsx", beans, response);
    }

    /**
     * @Description 查询最近启用的损耗率
     * @param vo 物料分类ids
     */
    @RequestMapping(value = "/getLossRate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> getLossRate(@RequestBody LossSetVO vo) {
        return CommonResponse.success("查询成功!",service.getLossRate(vo));
    }

    public void condition(QueryParam param){
          /*  1>【是否生效】为是的 + 第一版本没审批通过的（审批中的+自由态）单据；
            2> 如果生效的目标成本当前存在修订中的单据（未审批通过的），在操作列显示变更按钮跳转到对应单据。（【是否最新版本】=否  【是否生效】=是）
            3>【是否最新版本】=是  【是否生效】=是 时，操作列显示 修订 按钮，点击跳转到单据修订页面*/
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        //生效
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        //不生效
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("dutyVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
    }

    /**
     * @Description 查询最近启用的损耗率
     * @param vo 物料分类ids
     */
    @RequestMapping(value = "/getCodeOrSourceId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, MaterialCategoryVO>> getCodeOrSourceId(@RequestBody LossSetVO vo) {
        String msg = "查询成功!";
        MaterialCategoryVO mcv;
        Map<Long, MaterialCategoryVO> result = new HashMap<>();
        for (Long id : vo.getIds()) {
            mcv = materialApi.queryCategoryById(id).getData();
            result.put(id,mcv);
        }
        return CommonResponse.success(msg,result);
    }

    /**
     * @Description 校验一个项目只能做一个单据
     * @param
     */
    @RequestMapping(value = "/verify", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> verify(@RequestParam Long id) {
        String msg;
        List<LossSetEntity> list = service.list(new LambdaQueryWrapper<LossSetEntity>().eq(LossSetEntity::getProjectId,id));
        if (list.isEmpty()){
            msg = "校验通过！";
        }else {
            throw new BusinessException("当前项目已存在单据,不可新增,可进行变更!");
        }
        return CommonResponse.success(msg);
    }
}
