package com.ejianc.business.fjwz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fjwz.bean.InviteDetailEntity;
import com.ejianc.business.fjwz.bean.ScarpDetailEntity;
import com.ejianc.business.fjwz.bean.ScarpEntity;
import com.ejianc.business.fjwz.service.IInviteDetailService;
import com.ejianc.business.fjwz.service.IScarpDetailService;
import com.ejianc.business.fjwz.service.IScarpService;
import com.ejianc.business.fjwz.vo.ScarpDetailVO;
import com.ejianc.business.fjwz.vo.ScarpVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.wzxt.api.ICoordinationSetApi;
import com.ejianc.business.wzxt.vo.CoordinationSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 废旧物资出场
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scarp")
public class ScarpController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCARP";//此处需要根据实际修改

    @Autowired
    private IScarpService service;

    @Autowired
    private IScarpDetailService detailService;

    @Autowired
    private IInviteDetailService inviteDetailService;

    @Autowired
    private ICoordinationSetApi coordinationSetApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScarpVO> saveOrUpdate(@RequestBody ScarpVO saveOrUpdateVO) {
        CommonResponse<String>codeBatchByRuleCode=billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid());
        if (null == saveOrUpdateVO.getId() && codeBatchByRuleCode.isSuccess()) {
            if (saveOrUpdateVO.getBillCode() != null) {
                List<ScarpEntity> list = service.list(new QueryWrapper<ScarpEntity>().eq("bill_code", saveOrUpdateVO.getBillCode()));
                if (CollectionUtils.isNotEmpty(list)) {
                    return CommonResponse.error("单据编码重复！");
                }
            } else {
                saveOrUpdateVO.setBillCode(codeBatchByRuleCode.getData());
            }
            // 询价新增回写出场数量
            if (saveOrUpdateVO.getType() == 1) {
                List<InviteDetailEntity> list = new ArrayList<>();
                for (ScarpDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                    InviteDetailEntity inviteDetailEntity = inviteDetailService.selectById(detailVO.getSourceId());
                    inviteDetailEntity.setOutNum(ComputeUtil.safeAdd(inviteDetailEntity.getOutNum(), detailVO.getNum()));
                    list.add(inviteDetailEntity);
                }
                if (ListUtil.isNotEmpty(list)) {
                    inviteDetailService.saveOrUpdateBatch(list);
                }
            }
        } else {
            ScarpEntity scarpEntity = service.selectById(saveOrUpdateVO.getId());
            saveOrUpdateVO.setVersion(scarpEntity.getVersion());
            // 询价修改回写出场数量
            if (saveOrUpdateVO.getType() == 1) {
                List<InviteDetailEntity> list = new ArrayList<>();
                List<ScarpDetailVO> scarpDetailVOS = BeanMapper.mapList(scarpEntity.getDetailList(), ScarpDetailVO.class);
                Map<Long, ScarpDetailVO> map = scarpDetailVOS.stream().collect(Collectors.toMap(ScarpDetailVO::getId, Function.identity(), (key1, key2) -> key1));
                for (ScarpDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                    if (map.containsKey(detailVO.getId()) && map.get(detailVO.getId()).getNum().compareTo(detailVO.getNum())!=0) {
                        ScarpDetailVO scarpDetailVO = map.get(detailVO.getId());
                        if (detailVO.getNum().compareTo(scarpDetailVO.getNum()) == 1) {// 编辑值大于库存值
                            BigDecimal num = ComputeUtil.safeSub(detailVO.getNum(), scarpDetailVO.getNum());
                            InviteDetailEntity inviteDetailEntity = inviteDetailService.selectById(detailVO.getSourceId());
                            inviteDetailEntity.setOutNum(ComputeUtil.safeAdd(inviteDetailEntity.getOutNum(), num));
                            list.add(inviteDetailEntity);
                        } else if (detailVO.getNum().compareTo(scarpDetailVO.getNum()) == -1){// 编辑值小于库存值
                            BigDecimal num = ComputeUtil.safeSub(scarpDetailVO.getNum(), detailVO.getNum());
                            InviteDetailEntity inviteDetailEntity = inviteDetailService.selectById(detailVO.getSourceId());
                            inviteDetailEntity.setOutNum(ComputeUtil.safeSub(inviteDetailEntity.getOutNum(), num));
                            list.add(inviteDetailEntity);
                        }
                    }
                }
                if (ListUtil.isNotEmpty(list)) {
                    inviteDetailService.saveOrUpdateBatch(list);
                }
            }
        }
        // 汇总材料分类
        List<ScarpDetailVO> detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        saveOrUpdateVO.setMaterialTypeNames(materialTypeNames);

        if (saveOrUpdateVO.getPayState() == null) {
            saveOrUpdateVO.setPayState(1);
        }
        ScarpEntity entity = BeanMapper.map(saveOrUpdateVO, ScarpEntity.class);
    	service.saveOrUpdate(entity, false);
    	ScarpVO vo = BeanMapper.map(entity, ScarpVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 修改支付状态
     * @param id
     */
    @RequestMapping(value = "/changePayState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changePayState(Long id,Integer payState) {
        ScarpEntity entity = service.selectById(id);
        entity.setPayState(payState);
        service.saveOrUpdate(entity);
        return CommonResponse.success("修改成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScarpVO> queryDetail(Long id) {
    	ScarpEntity entity = service.selectById(id);
    	ScarpVO vo = BeanMapper.map(entity, ScarpVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScarpVO> vos) {
        List<Long> ids = new ArrayList<>();
        List<Long> scarpIds = new ArrayList<>();
        List<ScarpEntity> entityList = new ArrayList<>();
        List<ScarpDetailEntity> detailEntities = new ArrayList<>();
        List<InviteDetailEntity> inviteDetailEntityList = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (ScarpVO vo : vos) {
                ids.add(vo.getId());
            }
            entityList = service.list(new QueryWrapper<ScarpEntity>().in("id", ids).eq("type", 1));
        }
         if(ListUtil.isNotEmpty(entityList)){
            for (ScarpEntity entity : entityList) {
                scarpIds.add(entity.getId());
            }
             detailEntities = detailService.list(new QueryWrapper<ScarpDetailEntity>().in("scarp_id", scarpIds));
             for (ScarpDetailEntity entity : detailEntities) {
                 InviteDetailEntity inviteDetailEntity = inviteDetailService.selectById(entity.getSourceId());
                 inviteDetailEntity.setOutNum(ComputeUtil.safeSub(inviteDetailEntity.getOutNum(),entity.getNum()));
                 inviteDetailEntityList.add(inviteDetailEntity);
             }
             inviteDetailService.saveOrUpdateBatch(inviteDetailEntityList);
         }
        service.removeByIds(vos.stream().map(ScarpVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScarpVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("enquiryName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialTypeNames");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ScarpEntity> page = service.queryPage(param,false);
        IPage<ScarpVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScarpVO.class));
        for (ScarpVO vo : pageData.getRecords()) {
            switch (vo.getPayState()) {
                case 0: vo.setPayStateName("已支付");break;
                case 1: vo.setPayStateName("未支付");break;
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ScarpVO> list = BeanMapper.mapList(service.queryList(param),ScarpVO.class);
        for (ScarpVO vo : list) {
            switch (vo.getPayState()) {
                case 0: vo.setPayStateName("已支付");break;
                case 1: vo.setPayStateName("未支付");break;
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("scarp-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refScarpData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScarpVO>> refScarpData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ScarpEntity> page = service.queryPage(param,false);
        IPage<ScarpVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScarpVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryParentOrg 查询上级组织
     * @param orgId
     */
    @RequestMapping(value = "/queryParentOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(iOrgApi.detailById(orgId).getData().getParentId());
        return CommonResponse.success(orgVO.getData());
    }

    /**
     * @Description queryParentOrg 查询上级组织
     * @param orgId
     */
    @RequestMapping(value = "/queryCoordinationSet", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CoordinationSetVO> queryCoordinationSet(Long orgId) {
        return coordinationSetApi.queryCoordinationSet(null != orgId ? orgId : InvocationInfoProxy.getOrgId());
    }

    /**
     * @Description 生成出门证
     */
    @RequestMapping(value = "/pushOpApply", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> pushOpApply(@RequestParam Long id) {
        return CommonResponse.success("生成出门证成功！", service.pushOpApply(id));
    }
}
