package com.ejianc.business.fjwz.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TenderStageEnum {


    INVITE(0, "询价立项"),
    DOCUMENT(1, "询价公告"),
    TALK(2, "洽商谈判"),
    PICKETAGE(3, "询价结果"),
    WASTE(4, "中止询价");
    private final Integer changeStateCode;
    private final String description;
    private static Map<Integer, TenderStageEnum> enumMap = new HashMap();

    private TenderStageEnum(Integer changeStateCode, String description) {
        this.changeStateCode = changeStateCode;
        this.description = description;
    }

    public Integer getChangeStateCode() {
        return this.changeStateCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static TenderStageEnum getEnumByStateCode(Integer changeStateCode) {
        return (TenderStageEnum)enumMap.get(changeStateCode);
    }

    static {
        enumMap = (Map)EnumSet.allOf(TenderStageEnum.class).stream().collect(Collectors.toMap(TenderStageEnum::getChangeStateCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
