package com.ejianc.business.fjwz.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.fjwz.vo.InviteDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.fjwz.bean.InviteDetailEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 询价立项-子表
 *
 * @author generator
 *
 */
@Mapper
public interface InviteDetailMapper extends BaseCrudMapper<InviteDetailEntity> {
    @Select("select *\n" +
            "\t\tfrom (SELECT SUM(d.tender_num) as tenderNum,p.tenant_id,\n" +
            "\t\t\t\t\t p.project_id,\n" +
            "\t\t\t\t\t d.invite_id,\n" +
            "\t\t\t\t\t d.material_id as id,\n" +
            "\t\t\t\t\t d.material_id,\n" +
            "\t\t\t\t\t d.material_source_id,\n" +
            "\t\t\t\t\t d.material_name,\n" +
            "\t\t\t\t\t d.material_type_id,\n" +
            "\t\t\t\t\t d.material_type_name,\n" +
            "\t\t\t\t\t d.material_code,\n" +
            "\t\t\t\t\t d.unit as unitName,\n" +
            "\t\t\t\t\t d.spec\n" +
            "\t\t\t  from ejc_fjwz_invite_detail d\n" +
            "\t\t\t\t LEFT JOIN ejc_fjwz_invite p on p.id = d.invite_id\n" +
            "\t\t\t  WHERE p.dr = 0\n" +
            "\t\t\t\tand d.dr = 0\n" +
            "\t\t\t\tand p.tender_stage != 4 and d.material_id in (${ids})\n" +
            "\t\t\t  GROUP BY d.material_id, p.project_id\n" +
            "\t\t\t  order by d.create_time desc) a\n" +
            "\t\t\t${ew.customSqlSegment}")
    List<InviteDetailVO> getByMaterialId(@Param("ids") String ids, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);
}
