package com.ejianc.business.fjwz.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.fjwz.vo.ScarpDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.fjwz.bean.ScarpDetailEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 废旧物资出场明细
 *
 * @author generator
 *
 */
@Mapper
public interface ScarpDetailMapper extends BaseCrudMapper<ScarpDetailEntity> {

    @Select("select *\n" +
            "\t\tfrom (SELECT SUM(d.num) as num,p.tenant_id,\n" +
            "\t\t\t\t\t p.project_id,\n" +
            "\t\t\t\t\t d.material_id as id,\n" +
            "\t\t\t\t\t d.material_id,\n" +
            "\t\t\t\t\t d.material_source_id,\n" +
            "\t\t\t\t\t d.material_name,\n" +
            "\t\t\t\t\t d.material_type_id,\n" +
            "\t\t\t\t\t d.material_type_name,\n" +
            "\t\t\t\t\t d.material_code,\n" +
            "\t\t\t\t\t d.unit_name as unitName,\n" +
            "\t\t\t\t\t d.spec\n" +
            "\t\t\t  from ejc_fjwz_scarp_detail d\n" +
            "\t\t\t\t LEFT JOIN ejc_fjwz_scarp p on p.id = d.scarp_id\n" +
            "\t\t\t  WHERE p.dr = 0\n" +
            "\t\t\t\tand d.dr = 0\n" +
            "\t\t\t\tand p.type=2 and d.material_id in (${ids})\n" +
            "\t\t\t  GROUP BY d.material_id, p.project_id\n" +
            "\t\t\t  order by d.create_time desc) a\n" +
            "\t\t\t${ew.customSqlSegment}")
    List<ScarpDetailVO> getByMaterialId(@Param("ids") String ids, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);
}
