package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.*;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.mapper.DocumentMapper;
import com.ejianc.business.fjwz.service.*;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.*;
import com.ejianc.business.fjwz.vo.GF.UpdateGFVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.ejianc.framework.core.kit.mapper.BeanMapper.map;
import static com.ejianc.framework.core.kit.mapper.BeanMapper.mapList;

/**
 * 询价公告-主表
 *
 * @author generator
 *
 */
@Service("documentService")
public class DocumentServiceImpl extends BaseServiceImpl<DocumentMapper, DocumentEntity> implements IDocumentService{

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "cscec5b-document-code";//此处需要根据实际修改
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ITalkService talkService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    @Autowired
    private IProjectApi projectApi;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.updateTimeOrStateUrl}")
    private String updateTimeOrStateUrl;
    @Value("${openApi.wjFjwzInsertUrl}")
    private String wjFjwzInsertUrl;


    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Override
    public DocumentVO saveDocument(Long inviteId) {
        DocumentEntity entity = new DocumentEntity();
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //查询公告主表信息
        InviteEntity inviteEntity = inviteService.selectById(inviteId);
        //复制主表信息
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectSourceId(inviteEntity.getProjectSourceId());
        entity.setInviteId(inviteId);
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgSourceId(inviteEntity.getParentOrgSourceId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectCode(inviteEntity.getProjectCode());
        entity.setDocumentName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        entity.setUnitSourceId(inviteEntity.getUnitSourceId());
        entity.setDoucumentLinkId(sessionManager.getUserContext().getEmployeeId());
        entity.setDoucumentLinkName(sessionManager.getUserContext().getEmployeeName());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        super.saveOrUpdate(entity, false);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.DOCUMENT.getChangeStateCode());
        inviteEntity.setNextFlag(0);
        inviteService.updateById(inviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("询价公告");
        processEntity.setTenderId(inviteEntity.getId());
        processEntity.setFrontendUrl("invite/documentCard");
        processService.saveOrUpdate(processEntity);
        DocumentVO vo = map(entity, DocumentVO.class);

        vo.setInviteDetailList(mapList(inviteEntity.getInviteDetailList(),InviteDetailVO.class));
        vo.setInviteSupplierList(mapList(inviteEntity.getInviteSupplierlList(),InviteSupplierVO.class));
        vo.setTenderStage(inviteEntity.getTenderStage());

        return vo;
    }
    @Transactional
    @Override
    public DocumentVO publishDocument(Long id) {
        //更新发布状态
        DocumentEntity documentEntity = super.selectById(id);
        documentEntity.setPublishFlag(0);
        super.updateById(documentEntity);
        DocumentVO documentVO = queryDetail(id);
//        CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectBySourceId(documentEntity.getProjectSourceId());
//        ProjectRegisterVO projectRegisterVO = projectRegisterVOCommonResponse.getData();
        List<InviteDetailVO> inviteDetailList = documentVO.getInviteDetailList();
        String disposeContent = inviteDetailList.stream().filter(x -> StringUtils.isNotBlank(x.getMaterialTypeName())).map(InviteDetailVO::getMaterialTypeName).collect(Collectors.joining(","));
        documentVO.setDisposeContent(disposeContent);

        //推送供应商
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        String back = null;
        try {
            logger.info("---url:" + wjFjwzInsertUrl);
            logger.info("---询价公告发布入参:" + JSONObject.toJSON(documentVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(wjFjwzInsertUrl, JSONObject.toJSON(documentVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
            }else{
//                调用同步方法失败，输出错误信息
                throw new BusinessException(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            throw new BusinessException("推送供方公告信息失败");
        }

        return queryDetail(id);
    }

    @Override
    public Boolean supplierPushSell(DocumentSupplierVO documentSupplierVO) {
        String s = JSONObject.toJSONString(documentSupplierVO);
        logger.info("报价实体:"+s);
        Integer talkNum = documentSupplierVO.getTalkNum();
        Long inviteId = documentSupplierVO.getInviteId();
        Long supplierId = documentSupplierVO.getSupplierId();
        LambdaQueryWrapper<DocumentEntity> lambdaDoc = Wrappers.<DocumentEntity>lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, inviteId);
        DocumentEntity documentEntity = super.getOne(lambdaDoc);
        Long documentEntityId = documentEntity.getId();
        //先删后增,删除同一轮数下供应商的信息
        //删除供应商
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, talkNum);
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentEntityId);
        lambdaSupplier.eq(DocumentSupplierEntity::getSupplierId, supplierId);
        documentSupplierService.remove(lambdaSupplier);
        //删除报价信息
        LambdaQueryWrapper<DocumentSellEntity> lambdaSell = Wrappers.<DocumentSellEntity>lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, documentEntityId);
        lambdaSell.eq(DocumentSellEntity::getSupplierId, supplierId);
        documentSellService.remove(lambdaSell);

        //新增供应商
        DocumentSupplierEntity documentSupplierEntity = map(documentSupplierVO, DocumentSupplierEntity.class);
        documentSupplierEntity.setDocumentId(documentEntityId);
        documentSupplierService.save(documentSupplierEntity);
        //新增报价信息
        List<DocumentSellEntity> documentSellEntityList = mapList(documentSupplierVO.getDocumentSellList(), DocumentSellEntity.class);
        documentSellEntityList.forEach(p -> p.setDocumentId(documentEntityId));
        documentSellService.saveBatch(documentSellEntityList);

        return true;
    }

    @Override
    public DocumentSupplierVO getSellInfoById(Long supplierId, Long documentId) {
        DocumentSupplierVO documentSupplierVO = getSellInfo(supplierId, documentId,0);
        return documentSupplierVO;
    }

    private DocumentSupplierVO getSellInfo(Long supplierId, Long documentId,Integer talkNum) {
        //查询供应商
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, talkNum);
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentId);
        lambdaSupplier.eq(DocumentSupplierEntity::getSupplierId, supplierId);
        DocumentSupplierEntity documentSupplierEntity = documentSupplierService.getOne(lambdaSupplier);
        //获取报价信息
        LambdaQueryWrapper<DocumentSellEntity> lambdaSell = Wrappers.<DocumentSellEntity>lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, documentId);
        lambdaSell.eq(DocumentSellEntity::getSupplierId, supplierId);
        List<DocumentSellEntity> documentSellEntityList = documentSellService.list(lambdaSell);
        DocumentSupplierVO documentSupplierVO = BeanMapper.map(documentSupplierEntity, DocumentSupplierVO.class);
        List<DocumentSellVO> documentSellVOS = BeanMapper.mapList(documentSellEntityList, DocumentSellVO.class);
        documentSupplierVO.setDocumentSellList(documentSellVOS);
        DocumentEntity documentEntity = super.selectById(documentId);
        documentSupplierVO.setBidFlag(documentEntity.getBidFlag());
        return documentSupplierVO;
    }

    @Override
    public DocumentVO bidDocument(Long id) {
        //更新开标状态
        DocumentEntity documentEntity = super.selectById(id);
        documentEntity.setBidFlag(0);
        documentEntity.setBidTime(new Date());
        super.updateById(documentEntity);

        //回写供方
        UpdateGFVO updateGFVO = new UpdateGFVO();
        updateGFVO.setType(2);
        updateGFVO.setSourceId(Long.toString(documentEntity.getInviteId()));
        updateGFVO.setBillDate(documentEntity.getBidTime());
        updateGFVO.setPkCreator("hnxpt");
        updateGFVO.setSysmark("hnxpt");
        updateGFVO.setCreatorName("五局新平台");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        updateGFVO.setCreatorDate(simpleDateFormat.format(new Date()));
        //推送供应商
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        String back = null;
        try {
            logger.info("---url:" + updateTimeOrStateUrl);
            logger.info("---开标推送供方入参:" + JSONObject.toJSON(updateGFVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(updateTimeOrStateUrl, JSONObject.toJSON(updateGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
            }else{
//                调用同步方法失败，输出错误信息
                throw new BusinessException(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            throw new BusinessException("推送供方公告信息失败");
        }

        return queryDetail(id);
    }

    @Override
    public DocumentVO extendDocument(DocumentRecordVO documentRecordVO) {
        //保存记录
        DocumentRecordEntity documentRecordEntity = BeanMapper.map(documentRecordVO, DocumentRecordEntity.class);
        documentRecordService.save(documentRecordEntity);
        //更新主表时间
        DocumentEntity stuffDocumentEntity = super.selectById(documentRecordVO.getDocumentId());
        stuffDocumentEntity.setOfferEndTime(documentRecordVO.getNewTime());
        boolean b = super.updateById(stuffDocumentEntity);

        //推送供方
        UpdateGFVO updateGFVO = new UpdateGFVO();
        updateGFVO.setBillDate(documentRecordVO.getNewTime());
        updateGFVO.setType(0);
        updateGFVO.setSourceId(Long.toString(stuffDocumentEntity.getInviteId()));
        updateGFVO.setPkCreator("hnxpt");
        updateGFVO.setSysmark("hnxpt");
        updateGFVO.setCreatorName("五局新平台");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        updateGFVO.setCreatorDate(simpleDateFormat.format(documentRecordVO.getNewTime()));
        //推送供应商
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        String back = null;
        try {
            logger.info("---url:" + updateTimeOrStateUrl);
            logger.info("---询价公告延长时间入参:" + JSONObject.toJSON(updateGFVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(updateTimeOrStateUrl, JSONObject.toJSON(updateGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
            }else{
//                调用同步方法失败，输出错误信息
                throw new BusinessException(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            throw new BusinessException("推送供方公告信息失败");
        }
        return null;
    }

    @Override
    public DocumentVO queryDetail(Long id) {
       return queryDocDetail(id,0);
    }
    @Override
    public DocumentVO queryDocDetail(Long id, Integer talkNum) {
        //获取询价立项id
        DocumentEntity documentEntity = super.selectById(id);
        DocumentVO documentVO = BeanMapper.map(documentEntity, DocumentVO.class);
        Long inviteId = documentEntity.getInviteId();
        InviteEntity inviteEntity = inviteService.selectById(inviteId);
        documentVO.setInviteSupplierList(BeanMapper.mapList(inviteEntity.getInviteSupplierlList(),InviteSupplierVO.class));
        documentVO.setInviteDetailList(BeanMapper.mapList(inviteEntity.getInviteDetailList(),InviteDetailVO.class));
        documentVO.setInviteName(inviteEntity.getTenderName());
        //是否开标 控制是否返回金额等数据 ,是否开标,0-是,1-否
        List<DocumentSupplierVO> documentSupplierList = documentVO.getDocumentSupplierList();
        List<DocumentSupplierVO> documentSupplierVOS = documentSupplierList.stream().filter(s -> s.getTalkNum().equals(talkNum)).collect(Collectors.toList());
        if (documentVO.getBidFlag() == 1){
            for (DocumentSupplierVO documentSupplierVO : documentSupplierVOS){
                documentSupplierVO.setTenderDate(null);
                documentSupplierVO.setOfferTime(null);
                documentSupplierVO.setMemo(null);
                documentSupplierVO.setLinkId(null);
                documentSupplierVO.setLinkMobile(null);
                documentSupplierVO.setLinkName(null);
                documentSupplierVO.setTaxMemo(null);
            }
        }
        documentVO.setDocumentSupplierList(documentSupplierVOS);
        documentVO.setDocumentSupplierSellList(documentSupplierVOS);
        //处理按材料查看报价信息数据
        List<InviteDetailVO> inviteDetailVOS = BeanMapper.mapList(inviteEntity.getInviteDetailList(), InviteDetailVO.class);
        //获取报价信息
        LambdaQueryWrapper<DocumentSellEntity> lambdaSell = Wrappers.<DocumentSellEntity>lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(DocumentSellEntity::getDocumentId, id);
        List<DocumentSellEntity> documentSellEntityList = documentSellService.list(lambdaSell);
        List<DocumentSellVO> documentSellVOS = BeanMapper.mapList(documentSellEntityList, DocumentSellVO.class);
        Map<Long, List<DocumentSellVO>> sellMap = documentSellVOS.stream().
                collect(Collectors.groupingBy(DocumentSellVO::getInviteDetailId));
        for (InviteDetailVO inviteDetailVO : inviteDetailVOS){
            if (sellMap.containsKey(inviteDetailVO.getId())){
                List<DocumentSellVO> documentSellList = sellMap.get(inviteDetailVO.getId());
//                if (documentVO.getBidFlag() == 1){
//                    for (DocumentSellVO documentSellVO : documentSellList){
//                        documentSellVO.setSupplierMemo(null);
//                        documentSellVO.setPriceTax(null);
//                        documentSellVO.setSellMoneyTax(null);
//                    }
//                }
                inviteDetailVO.setDocumentSupplierSellList(documentSellList);

            }

        }
        documentVO.setDetailSupplierList(inviteDetailVOS);
        documentVO.setTenderStage(inviteEntity.getTenderStage());

        return documentVO;
    }

    @Override
    public DocumentSupplierVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        TalkEntity talkEntity = talkService.selectById(talkId);
        DocumentSupplierEntity documentSupplierEntity = documentSupplierService.selectById(supplierDetailId);

        LambdaQueryWrapper<DocumentSupplierEntity> lambdaDocSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaDocSupplier.eq(DocumentSupplierEntity::getDocumentId, talkEntity.getDocumentId());
        lambdaDocSupplier.eq(DocumentSupplierEntity::getSupplierId, documentSupplierEntity.getSupplierId());
        List<DocumentSupplierEntity> documentSupplierEntities = documentSupplierService.list(lambdaDocSupplier);
        Map<Integer, DocumentSupplierEntity> talkSupplierMap = documentSupplierEntities.stream().collect(Collectors.toMap(DocumentSupplierEntity::getTalkNum, Function.identity()));


        Integer talkNum = talkEntity.getTalkNum();
        if (talkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        List<DocumentSupplierVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0; a <= talkNum; a++) {
            DocumentSupplierVO documentSupplierVO = new DocumentSupplierVO();
            documentSupplierVO.setTalkNum(a);
            if (a == 0) {
                name = "首次报价";
            }
            else {
                name = "第" + a + "轮报价";
            }
            DocumentSupplierEntity documentSupplier = talkSupplierMap.get(a);
            documentSupplierVO.setTalkNumName(name);
            documentSupplierVO.setMoneyTax(documentSupplier.getMoneyTax());
            documentSupplierVO.setTalkNum(a);
            talkVOArrayList.add(documentSupplierVO);
        }

        DocumentSupplierVO documentSupplierVO = new DocumentSupplierVO();
        documentSupplierVO.setLinkName(documentSupplierEntity.getLinkName());
        documentSupplierVO.setLinkMobile(documentSupplierEntity.getLinkMobile());
        documentSupplierVO.setOfferTime(documentSupplierEntity.getOfferTime());
        documentSupplierVO.setTaxMemo(documentSupplierEntity.getTaxMemo());
        documentSupplierVO.setSupplierName(documentSupplierEntity.getSupplierName());
        //查询供应商下所有报价信息
        LambdaQueryWrapper<DocumentSellEntity> lambdaDocSell = Wrappers.<DocumentSellEntity>lambdaQuery();
        lambdaDocSell.eq(DocumentSellEntity::getDocumentId, talkEntity.getDocumentId());
        lambdaDocSell.eq(DocumentSellEntity::getSupplierId, documentSupplierEntity.getSupplierId());
        List<DocumentSellEntity> documentSellEntities = documentSellService.list(lambdaDocSell);

        ArrayList<DocumentSellEntity> documentSellTalk = new ArrayList<>();
        for (DocumentSupplierVO documentSupplier : talkVOArrayList) {
            Integer talkN = documentSupplier.getTalkNum();
            List<DocumentSellEntity> documentSellEntityList = documentSellEntities.stream().filter(s -> s.getTalkNum().equals(talkN)).collect(Collectors.toList());
            List<DocumentSellVO> documentSellVOS = BeanMapper.mapList(documentSellEntityList, DocumentSellVO.class);
            documentSupplier.setDocumentSellList(documentSellVOS);
        }
        List<DocumentSupplierVO> documentSupplierVOS = talkVOArrayList.stream().sorted(Comparator.comparing(DocumentSupplierVO::getTalkNum).reversed())
                .collect(Collectors.toList());
        documentSupplierVO.setDocumentTalkList(documentSupplierVOS);
         return documentSupplierVO;


    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
//        Set<String> keys = redisTemplate.keys("X-Open-Token");
//        if (CollectionUtils.isNotEmpty(keys)) {
//            redisTemplate.delete(keys);
//        }

        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------"+redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        }else{
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if("200".equals(json.get("code").toString())){
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                }else{
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public DocumentSupplierVO getPicSellInfoById(Long inviteId,Long supplierId) {
        LambdaQueryWrapper<DocumentEntity> lambdaDoc = Wrappers.<DocumentEntity>lambdaQuery();
        lambdaDoc.eq(DocumentEntity::getInviteId, inviteId);
        DocumentEntity documentEntity = super.getOne(lambdaDoc);
        //查询最大轮数
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, documentEntity.getId());
        List<DocumentSupplierEntity> supplierEntityList = documentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(DocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();
        DocumentSupplierVO documentSupplierVO = getSellInfo(supplierId, documentEntity.getId(),talkNumMax);
        return documentSupplierVO;
    }


}
