package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.*;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.*;
import com.ejianc.business.fjwz.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.InviteMapper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.ejianc.framework.core.kit.mapper.BeanMapper.map;
import static com.ejianc.framework.core.kit.mapper.BeanMapper.mapList;

/**
 * 询价立项-主表
 *
 * @author generator
 *
 */
@Service("inviteService")
public class InviteServiceImpl extends BaseServiceImpl<InviteMapper, InviteEntity> implements IInviteService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDisposeService disposeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IScarpService scarpService;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IDocumentSupplierService documentSupplierService;
    private static final String BILL_CODE = "cscec5b-invite-code";//此处需要根据实际修改

    @Override
    public InviteVO saveOrUpdate(InviteVO saveOrUpdateVO) {
        //查询项目部上级组织的的来源id
//        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(saveOrUpdateVO.getParentOrgId());
//        if(!orgParentVo.isSuccess()) {
//            throw new BusinessException("网络异常， 查询组织详情失败， 请稍后再试");
//        }
//
//
//        saveOrUpdateVO.setParentOrgSourceId(orgParentVo.getData().getSourceId());
        InviteEntity inviteEntity = BeanMapper.map(saveOrUpdateVO, InviteEntity.class);
        if (inviteEntity.getId() == null || inviteEntity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                inviteEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        inviteEntity.setNextFlag(1);
        inviteEntity.setTenderStage(TenderStageEnum.INVITE.getChangeStateCode());

        //处理物资分类汇总
        List<InviteDetailEntity> inviteDetailList = inviteEntity.getInviteDetailList();
        String materialTypeNames = inviteDetailList.stream().filter(x -> StringUtils.isNotBlank(x.getMaterialTypeName())).map(InviteDetailEntity::getMaterialTypeName).collect(Collectors.joining(","));
        inviteEntity.setMaterialTypeNames(materialTypeNames);

        super.saveOrUpdate(inviteEntity, false);
        //回写进展表
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(inviteEntity.getId());
            processEntity.setBillName("询价立项");
            processEntity.setTenderId(inviteEntity.getId());
            processEntity.setFrontendUrl("invite/card");
            processService.saveOrUpdate(processEntity);

        }
        InviteVO vo = map(inviteEntity, InviteVO.class);
        return vo;

    }
    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        InviteEntity inviteEntity = super.selectById(tenderId);
        InviteVO vo = BeanMapper.map(inviteEntity, InviteVO.class);
        //0-正常,1-终止
        Integer status = 0;
        if (vo.getTenderStage().equals(TenderStageEnum.WASTE.getChangeStateCode())){
            status = 1;
        }
        map.put("abolishType", status);
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public AnalysisVO getNum() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        AnalysisVO analysisVO = new AnalysisVO();

        //获取本下累计使用项目数  //获取累计处置次数
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<DisposeEntity> lambdaDis = Wrappers.<DisposeEntity>lambdaQuery();
        lambdaDis.in(DisposeEntity::getBillState, billStates);
        lambdaDis.in(DisposeEntity::getOrgId, commonOrgIds);
        List<DisposeEntity> disposeEntityList = disposeService.list(lambdaDis);
        BigDecimal projectNum = BigDecimal.ZERO;
        BigDecimal czNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(disposeEntityList)){
            List<Long> projectIds = disposeEntityList.stream().map(DisposeEntity::getProjectId).distinct().collect(Collectors.toList());
            long count = projectIds.stream().count();
            BigDecimal proNum = BigDecimal.valueOf(count);
            projectNum = proNum;
            long cz = disposeEntityList.stream().count();
            czNum = BigDecimal.valueOf(cz);
        }
        analysisVO.setProjectNum(projectNum);
        analysisVO.setCzNum(czNum);

        //询价次数
        LambdaQueryWrapper<InviteEntity> lambdaInvite = Wrappers.<InviteEntity>lambdaQuery();
        lambdaInvite.in(InviteEntity::getBillState, billStates);
        lambdaInvite.in(InviteEntity::getOrgId, commonOrgIds);
        List<InviteEntity> inviteEntityList = super.list(lambdaInvite);
        BigDecimal xjNum = BigDecimal.ZERO;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(inviteEntityList)){
            long count = inviteEntityList.stream().count();
            BigDecimal num = BigDecimal.valueOf(count);
            xjNum = num;
            //累计处置总金额
            List<Long> inviteIds = inviteEntityList.stream().filter(s -> s.getTenderStage() == 3).map(InviteEntity::getId).distinct().collect(Collectors.toList());
            logger.info("getNuminviteIds:{}", JSONObject.toJSONString(inviteIds));
            if (CollectionUtils.isNotEmpty(inviteIds)){
                logger.info("getNum测试:{}", JSONObject.toJSONString(inviteIds));
                logger.info("getNum测试:{}", inviteIds.toString());
                logger.info("getNumsize:{}", inviteIds.size());
                LambdaQueryWrapper<DocumentSupplierEntity> lambdaSup = Wrappers.<DocumentSupplierEntity>lambdaQuery();
                lambdaSup.in(DocumentSupplierEntity::getInviteId, inviteIds);
                lambdaSup.eq(DocumentSupplierEntity::getTenderFlag, 1);
                List<DocumentSupplierEntity> documentSupplierEntityList = documentSupplierService.list(lambdaSup);
                if (CollectionUtils.isNotEmpty(documentSupplierEntityList)){
                    moneyTaxNum = documentSupplierEntityList.stream().map(DocumentSupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }

        }
        analysisVO.setXjNum(xjNum);
        analysisVO.setMoneyNum(moneyTaxNum);

        BigDecimal realMoneyNum = BigDecimal.ZERO;
        LambdaQueryWrapper<ScarpEntity> queryWrapper = Wrappers.<ScarpEntity>lambdaQuery();
        queryWrapper.in(ScarpEntity::getBillState, billStates);
        queryWrapper.in(ScarpEntity::getOrgId, commonOrgIds);
        List<ScarpEntity> scarpEntities = scarpService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(scarpEntities)){
            for(ScarpEntity scarpEntity : scarpEntities){
                realMoneyNum = ComputeUtil.safeAdd(realMoneyNum, scarpEntity.getRealHandleMny());
            }
        }
        analysisVO.setRealMoneyNum(realMoneyNum);
        return analysisVO;
    }

    @Override
    public List<AnalysisVO> getPeriodMoney() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //获取时间区间
        List<AnalysisVO> analysisList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        //询价次数
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        LambdaQueryWrapper<InviteEntity> lambdaInvite = Wrappers.<InviteEntity>lambdaQuery();
        lambdaInvite.in(InviteEntity::getBillState, billStates);
        lambdaInvite.in(InviteEntity::getOrgId, commonOrgIds);
        List<InviteEntity> inviteEntityList = super.list(lambdaInvite);
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<String, List<DocumentSupplierVO>> periodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(inviteEntityList)){
            List<Long> inviteIds = inviteEntityList.stream().filter(s -> s.getTenderStage() == 3).map(InviteEntity::getId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIds)){
                LambdaQueryWrapper<DocumentSupplierEntity> lambdaSup = Wrappers.<DocumentSupplierEntity>lambdaQuery();
                lambdaSup.in(DocumentSupplierEntity::getInviteId, inviteIds);
                lambdaSup.eq(DocumentSupplierEntity::getTenderFlag, 1);
                List<DocumentSupplierEntity> documentSupplierEntityList = documentSupplierService.list(lambdaSup);
                if (CollectionUtils.isNotEmpty(documentSupplierEntityList)){
                    List<DocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(documentSupplierEntityList, DocumentSupplierVO.class);
                    for (DocumentSupplierVO documentSupplierVO : documentSupplierVOList){
                        Date updateTime = documentSupplierVO.getUpdateTime();
                        String period = sdf.format(updateTime);
                        documentSupplierVO.setPeriod(period);
                    }
                    periodMap = documentSupplierVOList.stream().collect(Collectors.groupingBy(DocumentSupplierVO::getPeriod));
                }
            }
        }

        for (int i = 6; i> 0;i--){

            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setPeriod(period);
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            if (periodMap.containsKey(period)){
                List<DocumentSupplierVO> documentSupplierVOList = periodMap.get(period);
                moneyTaxNum = documentSupplierVOList.stream().map(DocumentSupplierVO::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal bigDecimal = moneyTaxNum.divide(new BigDecimal(10000), 8, BigDecimal.ROUND_HALF_UP);
                analysisVO.setMoneyNum(moneyTaxNum);
            };
            analysisList.add(analysisVO);
            calendar.add(Calendar.MONTH, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> getPeriodCs() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //获取时间区间
        List<AnalysisVO> analysisList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String nowtime = sdf.format(new Date());
        List<String> periodList = new ArrayList<>();
        periodList.add(nowtime);
        //询价次数
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<DisposeEntity> lambdaDis = Wrappers.<DisposeEntity>lambdaQuery();
        lambdaDis.in(DisposeEntity::getBillState, billStates);
        lambdaDis.in(DisposeEntity::getOrgId, commonOrgIds);
        List<DisposeEntity> disposeEntityList = disposeService.list(lambdaDis);
        Map<String, List<DisposeVO>> periodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(disposeEntityList)){
            List<DisposeVO> disposeVOList = BeanMapper.mapList(disposeEntityList, DisposeVO.class);
            for (DisposeVO disposeVO : disposeVOList){
                Date updateTime = disposeVO.getBillDate();
                String period = sdf.format(updateTime);
                disposeVO.setPeriod(period);
            }
            periodMap = disposeVOList.stream().collect(Collectors.groupingBy(DisposeVO::getPeriod));
        }

        for (int i = 6; i> 0;i--){

            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            analysisVO.setPeriod(period);
            if (periodMap.containsKey(period)){
                List<DisposeVO> disposeVOList = periodMap.get(period);
                analysisVO.setFrequency(disposeVOList.size());
            };
            analysisList.add(analysisVO);
            calendar.add(Calendar.MONTH, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> getUseInfo(Long orgId) {
        List<AnalysisVO> analysisList = new ArrayList<>();
        CommonResponse<List<OrgVO>> childrenOrg = orgApi.getDirectChildrenByPid(orgId, null);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(childrenOrg.getData())){
            childrenOrg.getData().forEach(e -> {
                AnalysisVO analysisVO = new AnalysisVO();
                analysisVO.setOrgId(e.getId());
                analysisVO.setOrgName(e.getName());
                List<Long> commonOrgIds = new ArrayList<>();
                CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(e.getId());
                if(!orgListResp.isSuccess()) {
                    throw new BusinessException("查询组织信息失败！");
                }
                commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
                logger.info("getUseInfocommonOrgIds:{}", JSONObject.toJSONString(commonOrgIds));

                //获取累计处置次数
                List<Integer> billStates = new ArrayList<>();
                billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                LambdaQueryWrapper<DisposeEntity> lambdaDis = Wrappers.<DisposeEntity>lambdaQuery();
                lambdaDis.in(DisposeEntity::getBillState, billStates);
                lambdaDis.in(DisposeEntity::getOrgId, commonOrgIds);
                List<DisposeEntity> disposeEntityList = disposeService.list(lambdaDis);
                BigDecimal projectNum = BigDecimal.ZERO;
                BigDecimal czNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(disposeEntityList)){
                    List<Long> projectIds = disposeEntityList.stream().map(DisposeEntity::getProjectId).distinct().collect(Collectors.toList());
                    long count = projectIds.stream().count();
                    BigDecimal proNum = BigDecimal.valueOf(count);
                    projectNum = proNum;
                    long cz = disposeEntityList.stream().count();
                    czNum = BigDecimal.valueOf(cz);
                }
                analysisVO.setCzNum(czNum);

                //询价次数
                LambdaQueryWrapper<InviteEntity> lambdaInvite = Wrappers.<InviteEntity>lambdaQuery();
                lambdaInvite.in(InviteEntity::getBillState, billStates);
                lambdaInvite.in(InviteEntity::getOrgId, commonOrgIds);
                List<InviteEntity> inviteEntityList = super.list(lambdaInvite);
                BigDecimal xjNum = BigDecimal.ZERO;
                BigDecimal moneyTaxNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(inviteEntityList)){
                    long count = inviteEntityList.stream().count();
                    BigDecimal num = BigDecimal.valueOf(count);
                    xjNum = num;
                    //累计处置总金额

                    List<Long> inviteIds = inviteEntityList.stream().filter(s -> s.getTenderStage() == 3).map(InviteEntity::getId).distinct().collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(inviteIds)){
                        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSup = Wrappers.<DocumentSupplierEntity>lambdaQuery();
                        lambdaSup.in(DocumentSupplierEntity::getInviteId, inviteIds);
                        lambdaSup.eq(DocumentSupplierEntity::getTenderFlag, 1);
                        List<DocumentSupplierEntity> documentSupplierEntityList = documentSupplierService.list(lambdaSup);
                        if (CollectionUtils.isNotEmpty(documentSupplierEntityList)){
                            moneyTaxNum = documentSupplierEntityList.stream().map(DocumentSupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                    }


                }
                analysisVO.setXjNum(xjNum);
                analysisVO.setMoneyNum(moneyTaxNum);

                BigDecimal realMoneyNum = BigDecimal.ZERO;
                LambdaQueryWrapper<ScarpEntity> queryWrapper = Wrappers.<ScarpEntity>lambdaQuery();
                queryWrapper.in(ScarpEntity::getBillState, billStates);
                queryWrapper.in(ScarpEntity::getOrgId, commonOrgIds);
                List<ScarpEntity> scarpEntities = scarpService.list(queryWrapper);
                if(CollectionUtils.isNotEmpty(scarpEntities)){
                    for(ScarpEntity scarpEntity : scarpEntities){
                        realMoneyNum = ComputeUtil.safeAdd(realMoneyNum, scarpEntity.getRealHandleMny());
                    }
                }
                analysisVO.setRealMoneyNum(realMoneyNum);

                analysisList.add(analysisVO);

            });
        }
        return analysisList;
    }
}
