package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.fjwz.bean.LossSetEntity;
import com.ejianc.business.fjwz.enums.ChangeStateEnum;
import com.ejianc.business.fjwz.service.ILossSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("lossSet") 
public class LossSetBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ILossSetService service;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		updateEnableAndWriteBack(billId,true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		LossSetEntity entity = service.selectById(billId);
		if (entity.getLatestFlag() == 0) {
			return CommonResponse.error("只能撤回最新版本!");
		}
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	private void updateEnableAndWriteBack(Long billId, Boolean isPass){
		LossSetEntity entity = service.getById(billId);
		entity.setEnableState(Boolean.TRUE.equals(isPass)?1:0);
		entity.setEffectiveDate(new Date());
		service.saveOrUpdate(entity);
		//弃审,存在前版本，单据是否生效为是
		if(entity.getLastDutyId()!=null){
			LossSetEntity revise = service.getById(entity.getLastDutyId());
			revise.setChangeState(Boolean.TRUE.equals(isPass) ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
			revise.setEnableState(Boolean.TRUE.equals(!isPass)?1:0);
			service.saveOrUpdate(revise);
		}
	}

}
