package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.LossSetDetailEntity;
import com.ejianc.business.fjwz.enums.ChangeStateEnum;
import com.ejianc.business.fjwz.service.ILossSetDetailService;
import com.ejianc.business.fjwz.vo.LossSetVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.LossSetMapper;
import com.ejianc.business.fjwz.bean.LossSetEntity;
import com.ejianc.business.fjwz.service.ILossSetService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 损耗率设置
 *
 * @author generator
 *
 */
@Service("lossSetService")
public class LossSetServiceImpl extends BaseServiceImpl<LossSetMapper, LossSetEntity> implements ILossSetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private ILossSetDetailService detailService;

    @Override
    public LossSetVO changeTask(Long id) {
        LossSetEntity entity = super.selectById(id);
        entity.setId(null);
        entity.setBillState(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setDutyVersion(entity.getDutyVersion() + 1);
        entity.setChangeState(ChangeStateEnum.未变更.getCode());
        entity.setLastDutyId(id);
        entity.setLatestFlag(1);
        entity.setEnableState(0);
        entity.setCommonId(entity.getCommonId());
        for (LossSetDetailEntity detailEntity : entity.getLossSetDetailList()) {
            detailEntity.setLossId(null);
            detailEntity.setId(null);
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setUpdateUserCode(null);
        }
        super.saveOrUpdate(entity,false);
        //变更单保存
        if(entity.getLastDutyId()!=null){
            LossSetEntity revise = super.getById(entity.getLastDutyId());
            revise.setLatestFlag(0);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.变更中.getCode());
            super.saveOrUpdate(revise);
        }
        return BeanMapper.map(entity,LossSetVO.class);
    }

    @Override
    public List<LossSetVO> queryListById(Long id) {
        LossSetEntity entity = super.selectById(id);
        LambdaQueryWrapper<LossSetEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(LossSetEntity::getCommonId,entity.getCommonId());
        lambda.lt(LossSetEntity::getDutyVersion,entity.getDutyVersion());
        lambda.orderByDesc(LossSetEntity::getDutyVersion);
        List<LossSetEntity> entityList = super.list(lambda);
        List<LossSetVO> vos = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(entityList)){
            vos = BeanMapper.mapList(entityList, LossSetVO.class);
        }
        return vos;
    }

    @Override
    public Map<Long, BigDecimal> getLossRate(LossSetVO vo) {
        Map<Long, BigDecimal> result = new HashMap<>();
        LambdaQueryWrapper<LossSetEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(LossSetEntity::getOrgId,vo.getOrgId());
        queryWrapper.eq(LossSetEntity::getLatestFlag,1);
        queryWrapper.last("LIMIT 1");
        LossSetEntity entity = super.getOne(queryWrapper);
        if (entity==null){
            return result;
        }
        CommonResponse<List<MaterialCategoryVO>> voLists = materialApi.queryCategoryListByChildren(vo.getIds());
        logger.info("------------打印voLists------------"+ JSONObject.toJSON(voLists.getData()).toString());
        List<Long> vids = new ArrayList<>();
        List<Long> cids;
        Map<Long,MaterialCategoryVO> map;
        Map<Long,List<Long>> vidMap = new HashMap<>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(voLists.getData())){
            map = voLists.getData().stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (k1, k2) -> k2));
            for (Long id : vo.getIds()) {
                cids = Arrays.stream(map.get(id).getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                Collections.reverse(cids);
                vidMap.put(id, cids);
                vids.addAll(cids);
            }
            vids = vids.stream().distinct().collect(Collectors.toList());
        }else {
            throw new BusinessException("物料分类档案未查到当前分类及上级分类！");
        }
        List<LossSetDetailEntity> list = detailService.list(new QueryWrapper<LossSetDetailEntity>()
                .eq("loss_id",entity.getId())
                .in("material_type_id",vids));
        if (CollectionUtils.isEmpty(list)){
            return result;
        }
        Map<Long,LossSetDetailEntity> maps = list.stream().collect(Collectors.toMap(LossSetDetailEntity::getMaterialTypeId, Function.identity(), (k1, k2) -> k2));
        for (Long id : vo.getIds()) {
            if (result.containsKey(id)){
                continue;
            }
            cids = vidMap.get(id);
            for (Long cid : cids) {
                if (maps.containsKey(cid)){
                    result.put(id,maps.get(cid).getLossRate());
                    break;
                }
            }
        }
        return result;
    }
}
