package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fjwz.bean.ScarpDetailEntity;
import com.ejianc.business.op.api.IApplyApi;
import com.ejianc.business.op.vo.ApplyDetailVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.ScarpMapper;
import com.ejianc.business.fjwz.bean.ScarpEntity;
import com.ejianc.business.fjwz.service.IScarpService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 废旧物资出场
 *
 * @author generator
 *
 */
@Service("scarpService")
public class ScarpServiceImpl extends BaseServiceImpl<ScarpMapper, ScarpEntity> implements IScarpService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IApplyApi applyApi;

    @Override
    public ApplyVO pushOpApply(Long id) {
        ScarpEntity scarpEntity = selectById(id);
        ApplyVO applyVO = new ApplyVO();
        applyVO.setProjectId(scarpEntity.getProjectId());
        applyVO.setProjectName(scarpEntity.getProjectName());
        applyVO.setOrgId(scarpEntity.getOrgId());
        applyVO.setOrgName(scarpEntity.getOrgName());
        applyVO.setParentOrgId(scarpEntity.getParentOrgId());
        applyVO.setOutDate(new Date());
        applyVO.setCarNumber(scarpEntity.getCarNumber());
        String pcUrl = null;
        String mobileUrl = null;
        switch (scarpEntity.getType()){
            case 0:
                pcUrl = "http://wei.cscec5b.com.cn:9080/cscec5b-fjwz-frontend/#/scarp/card?id=" + scarpEntity.getId();
                mobileUrl = "http://wei.cscec5b.com.cn:9080/cscec5b-fjwz-mobile/#/scarp/card?id=" + scarpEntity.getId();
                break;
            case 1:
                pcUrl = "http://wei.cscec5b.com.cn:9080/cscec5b-fjwz-frontend/#/refCard/card?id=" + scarpEntity.getId();
                mobileUrl = "http://wei.cscec5b.com.cn:9080/cscec5b-fjwz-mobile/#/enquiryCard/card?id=" + scarpEntity.getId();
                break;
            case 2:
                pcUrl = "http://wei.cscec5b.com.cn:9080/cscec5b-fjwz-frontend/#/refCard/refApplyCard?id=" + scarpEntity.getId();
                mobileUrl = "http://wei.cscec5b.com.cn:9080/cscec5b-fjwz-mobile/#/enquiryCard/applyCard?id=" + scarpEntity.getId();
                break;
                default:
        }
        applyVO.setLinkUrlPc(pcUrl);
        applyVO.setLinkUrlMobile(mobileUrl);
        List<ApplyDetailVO> detailList = new ArrayList<>();
        for(ScarpDetailEntity detailEntity : scarpEntity.getDetailList()){
            ApplyDetailVO detailVO = new ApplyDetailVO();
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setSpec(detailEntity.getSpec());
            detailVO.setUnit(detailEntity.getUnitName());
            detailVO.setNum(detailEntity.getNum());
            detailVO.setReason("废旧物资出场");
            detailList.add(detailVO);
        }
        applyVO.setSourceId(String.valueOf(scarpEntity.getId()));
        applyVO.setSourceBillType("BT221115000000003");
        applyVO.setSourceBillSourceType("imgUpload1");
        applyVO.setDetailList(detailList);
        CommonResponse<ApplyVO> response = applyApi.push(applyVO);
        if (response.isSuccess() && null != response.getData()) {
            return response.getData();
        }else {
            logger.error(JSONObject.toJSONString(response));
            throw new BusinessException("生成出门证失败");
        }
    }
}
