package com.ejianc.business.fjwz.service.impl;

import com.ejianc.business.fjwz.service.IDocumentService;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.TalkRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.TalkRecordMapper;
import com.ejianc.business.fjwz.bean.TalkRecordEntity;
import com.ejianc.business.fjwz.service.ITalkRecordService;

/**
 * 洽商谈判-记录主表
 * 
 * @author generator
 * 
 */
@Service("talkRecordService")
public class TalkRecordServiceImpl extends BaseServiceImpl<TalkRecordMapper, TalkRecordEntity> implements ITalkRecordService{
    @Autowired
    private IDocumentService documentService;
    @Override
    public TalkRecordVO queryDetail(Long id) {
        TalkRecordEntity talkRecordEntity = super.selectById(id);
        TalkRecordVO talkRecordVO = BeanMapper.map(talkRecordEntity, TalkRecordVO.class);

        //确认轮数
        Integer talkNum = talkRecordVO.getTalkNum();
        DocumentVO documentVO = documentService.queryDocDetail(talkRecordVO.getDocumentId(), talkNum);
        talkRecordVO.setDetailSupplierList(documentVO.getDetailSupplierList());
        talkRecordVO.setDocumentSupplierList(documentVO.getDocumentSupplierList());
        return talkRecordVO;
    }
}
