package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fjwz.bean.*;
import com.ejianc.business.fjwz.enums.TenderStageEnum;
import com.ejianc.business.fjwz.service.*;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.DocumentVO;
import com.ejianc.business.fjwz.vo.GF.UpdateGFVO;
import com.ejianc.business.fjwz.vo.TalkDetailVO;
import com.ejianc.business.fjwz.vo.TalkRecordVO;
import com.ejianc.business.fjwz.vo.TalkVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.TalkMapper;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 洽商谈判-主表
 * 
 * @author generator
 * 
 */
@Service("talkService")
public class TalkServiceImpl extends BaseServiceImpl<TalkMapper, TalkEntity> implements ITalkService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IDocumentSupplierService documentSupplierService;
    @Autowired
    private IDocumentRecordService documentRecordService;
    @Autowired
    private IDocumentSellService documentSellService;
    @Autowired
    private ITalkRecordService talkRecordService;
    @Autowired
    private ITalkRecordDetailService talkRecordDetailService;
    @Autowired
    private IDocumentService documentService;
    @Autowired
    private ITalkDetailService talkDetailService;
    @Value("${openApi.updateTimeOrStateUrl}")
    private String updateTimeOrStateUrl;
    @Value("${openApi.insertTalkUrl}")
    private String insertTalkUrl;
    private static final String BILL_CODE = "cscec5b-talk-code";//此处需要根据实际修改
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public TalkVO saveTalk(Long documentId) {
        TalkEntity entity = new TalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        DocumentEntity documentEntity = documentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        documentService.saveOrUpdate(documentEntity);

        //查询询价立项信息
        InviteEntity inviteEntity = inviteService.selectById(documentEntity.getInviteId());
        entity.setProjectCode(documentEntity.getProjectCode());
        entity.setInviteId(documentEntity.getInviteId());
        entity.setProjectId(documentEntity.getProjectId());
        entity.setProjectSourceId(documentEntity.getProjectSourceId());
        entity.setProjectName(documentEntity.getProjectName());
        entity.setOrgId(documentEntity.getOrgId());
        entity.setOrgName(documentEntity.getOrgName());
        entity.setParentOrgId(documentEntity.getParentOrgId());
        entity.setParentOrgSourceId(documentEntity.getParentOrgSourceId());
        entity.setParentOrgName(documentEntity.getParentOrgName());
        entity.setUnitId(documentEntity.getUnitId());
        entity.setUnitName(documentEntity.getUnitName());
        entity.setUnitSourceId(documentEntity.getUnitSourceId());
        entity.setDocumentId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setTalkName(inviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.TALK.getChangeStateCode());
        inviteService.updateById(inviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(documentEntity.getInviteId());
        processEntity.setFrontendUrl("invite/talkCard");
        processService.saveOrUpdate(processEntity);

        TalkVO vo = BeanMapper.map(entity, TalkVO.class);
        return queryDetail(vo.getId());
    }

    @Override
    public TalkVO queryDetail(Long id) {
        TalkEntity talkEntity = super.selectById(id);
        TalkVO talkVO = BeanMapper.map(talkEntity, TalkVO.class);

        //确认轮数
        Integer talkNum = talkEntity.getTalkNum();
//        是否发布,0-是,1-否
        if (talkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        DocumentVO documentVO = documentService.queryDocDetail(talkEntity.getDocumentId(), talkNum);
        talkVO.setInviteDetailList(documentVO.getInviteDetailList());
        talkVO.setInviteSupplierList(documentVO.getInviteSupplierList());
        talkVO.setDetailSupplierList(documentVO.getDetailSupplierList());
        talkVO.setDocumentSupplierList(documentVO.getDocumentSupplierList());
        talkVO.setDocumentSupplierNowList(documentVO.getDocumentSupplierList());

        //查询变更历史记录
        LambdaQueryWrapper<TalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(TalkRecordEntity::getDocumentId,talkEntity.getDocumentId());
        lambdaRecord.orderByAsc(TalkRecordEntity::getTalkNum);
        List<TalkRecordEntity> talkRecordEntityList = talkRecordService.list(lambdaRecord);
        List<TalkRecordVO> talkRecordList = BeanMapper.mapList(talkRecordEntityList, TalkRecordVO.class);
        talkVO.setTalkRecordList(talkRecordList);

        InviteEntity inviteEntity = inviteService.selectById(documentVO.getInviteId());
        talkVO.setTenderStage(inviteEntity.getTenderStage());

        return talkVO;
    }

    @Override
    public TalkVO publishTalk(Long id) throws Exception {
        //更新发布状态
        TalkEntity talkEntity = super.selectById(id);
        talkEntity.setPublishFlag(0);
        super.updateById(talkEntity);

        //推送供方
        //推送供应商
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = documentService.getAccessToken(headers);
        String back = null;
//        try {
            logger.info("---url:" + insertTalkUrl);
            logger.info("---洽商谈判发布入参:" + JSONObject.toJSON(talkEntity).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(insertTalkUrl, JSONObject.toJSON(talkEntity).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
            }else{
//                调用同步方法失败，输出错误信息
                throw new BusinessException(jsonBack.getString("msg"));
            }
//        } catch (Exception e) {
//            throw new BusinessException("推送供方公告信息失败");
//        }


        return queryDetail(id);
    }

    @Override
    public TalkVO extendTalk(TalkDetailVO talkDetailVO) {
        TalkDetailEntity talkDetailEntity = BeanMapper.map(talkDetailVO, TalkDetailEntity.class);
        talkDetailService.save(talkDetailEntity);
        TalkEntity talkEntity = super.selectById(talkDetailVO.getTalkId());
        talkEntity.setTalkEndTime(talkDetailVO.getNewTime());
        boolean b = super.updateById(talkEntity);

        //推送供方
        UpdateGFVO updateGFVO = new UpdateGFVO();
        updateGFVO.setBillDate(talkDetailVO.getNewTime());
        updateGFVO.setType(1);
        updateGFVO.setSourceId(Long.toString(talkEntity.getInviteId()));
        updateGFVO.setPkCreator("hnxpt");
        updateGFVO.setSysmark("hnxpt");
        updateGFVO.setCreatorName("五局新平台");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        updateGFVO.setCreatorDate(simpleDateFormat.format(talkDetailVO.getNewTime()));

        //推送供应商
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = documentService.getAccessToken(headers);
        String back = null;
        try {
            logger.info("---url:" + updateTimeOrStateUrl);
            logger.info("---洽商谈判延长时间入参:" + JSONObject.toJSON(updateGFVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(updateTimeOrStateUrl, JSONObject.toJSON(updateGFVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
            }else{
//                调用同步方法失败，输出错误信息
                throw new BusinessException(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            throw new BusinessException("推送供方公告信息失败");
        }
        return queryDetail(talkDetailVO.getTalkId());
    }

    @Override
    public TalkVO againSaveTalk(Long id) {
        TalkEntity entity = new TalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        TalkEntity talkEntity = super.selectById(id);
        entity.setProjectCode(talkEntity.getProjectCode());
        entity.setProjectId(talkEntity.getProjectId());
        entity.setProjectSourceId(talkEntity.getProjectSourceId());
        entity.setProjectName(talkEntity.getProjectName());
        entity.setOrgId(talkEntity.getOrgId());
        entity.setOrgName(talkEntity.getOrgName());
        entity.setParentOrgId(talkEntity.getParentOrgId());
        entity.setParentOrgSourceId(talkEntity.getParentOrgSourceId());
        entity.setParentOrgName(talkEntity.getParentOrgName());
        entity.setDocumentId(talkEntity.getDocumentId());
        entity.setUnitId(talkEntity.getUnitId());
        entity.setUnitName(talkEntity.getUnitName());
        entity.setUnitSourceId(talkEntity.getUnitSourceId());
        entity.setInviteId(talkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(talkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        super.save(entity);

        //保存历史记录表
        TalkRecordEntity talkRecordEntity =  BeanMapper.map(talkEntity,TalkRecordEntity.class);
        talkRecordEntity.setTalkId(talkEntity.getId());
        talkRecordEntity.setId(null);
        talkRecordService.save(talkRecordEntity);

        //新增历史记录子表
        List<TalkDetailEntity> talkDetailList = talkEntity.getTalkDetailList();
        List<TalkRecordDetailEntity> talkRecordDetailEntityList = BeanMapper.mapList(talkDetailList,TalkRecordDetailEntity.class);
        for (TalkRecordDetailEntity talkRecordDetailEntity : talkRecordDetailEntityList){
            talkRecordDetailEntity.setId(null);
            talkRecordDetailEntity.setRecordId(talkRecordEntity.getId());
        }
        talkRecordDetailService.saveBatch(talkRecordDetailEntityList);
        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,talkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);

        //补全上一轮信息
        addLastSell(talkEntity.getTalkNum(),talkEntity.getDocumentId());



        return queryDetail(entity.getId());
    }

    @Override
    public TalkVO replenishSell(Long id) {
        TalkEntity talkEntity = super.selectById(id);

        Integer talkNum = talkEntity.getTalkNum();
        Long documentId = talkEntity.getDocumentId();
        addLastSell(talkNum,documentId);
        return new TalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        TalkEntity talkEntity = super.selectById(id);
        Integer talkNum = talkEntity.getTalkNum();
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, talkEntity.getDocumentId());
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, talkNum);
        List<DocumentSupplierEntity> supplierList = documentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(DocumentSupplierEntity::getDocumentId, talkEntity.getDocumentId());
        lambdaSupplierFirst.eq(DocumentSupplierEntity::getTalkNum, 0);
        List<DocumentSupplierEntity> supplierListFirst = documentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplier = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(DocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(DocumentSupplierEntity::getTalkNum, talkNum);
        List<DocumentSupplierEntity> supplierList = documentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<DocumentSupplierEntity> lambdaSupplierLast = Wrappers.<DocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(DocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(DocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<DocumentSupplierEntity> supplierListLast = documentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(DocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<DocumentSupplierEntity> documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<DocumentSupplierEntity> documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList,DocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0){
            return;
        }
        List<Long> supplierNewPk = documentSupplierEntityNewList.stream().map(DocumentSupplierEntity::getSupplierId).collect(Collectors.toList());

        //推送供应商数据提示信息
        for (DocumentSupplierEntity documentSupplierEntity : documentSupplierEntityNewList){
            documentSupplierEntity.setId(IdWorker.getId());
            documentSupplierEntity.setTalkNum(talkNum);
        }
        documentSupplierService.saveBatch(documentSupplierEntityNewList);
        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<DocumentSellEntity> lambdaSell = Wrappers.<DocumentSellEntity>lambdaQuery();
        lambdaSell.eq(DocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(DocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(DocumentSellEntity::getSupplierId, supplierNewPk);
        List<DocumentSellEntity> sellList = documentSellService.list(lambdaSell);
        for (DocumentSellEntity stuffDocumentSellEntity : sellList){
            stuffDocumentSellEntity.setId(null);
            stuffDocumentSellEntity.setTalkNum(talkNum);
        }
        documentSellService.saveBatch(sellList);
    }
}
