package com.ejianc.business.fjwz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fjwz.util.HttpTookit;
import com.ejianc.business.fjwz.vo.GF.UpdateGFVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fjwz.mapper.WasteMapper;
import com.ejianc.business.fjwz.bean.WasteEntity;
import com.ejianc.business.fjwz.service.IWasteService;
import java.util.Map;

/**
 * 中止询价
 * 
 * @author generator
 * 
 */
@Service("wasteService")
public class WasteServiceImpl extends BaseServiceImpl<WasteMapper, WasteEntity> implements IWasteService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.updateTimeOrStateUrl}")
    private String updateTimeOrStateUrl;

    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, WasteEntity wasteEntity) {
        String url = updateTimeOrStateUrl;
        UpdateGFVO purchase = new UpdateGFVO();
        purchase.setSourceId(String.valueOf(wasteEntity.getInviteId()));// 主键
        purchase.setSuspendLinkId(wasteEntity.getEmployeeId());
        purchase.setSuspendLinkName(wasteEntity.getEmployeeName());
        purchase.setSuspendLinkMobile(wasteEntity.getEmployeeMobile());
        purchase.setSuspendReason(wasteEntity.getMemo());
        purchase.setSuspendTime(wasteEntity.getApplyTime());
        purchase.setType(4);
        purchase.setPkCreator("hnxpt");
        purchase.setSysmark("hnxpt");
        purchase.setCreatorName("五局新平台");
        purchase.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSON.toJSON(purchase).toString());
            logger.info("---headers:" + JSON.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSON.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }
}
