package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.vo.GuardUserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 门岗人员实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("guardUser")
public class GuardUserController implements Serializable {
	private static final long serialVersionUID = 1L;


    @Autowired
    private IGuardUserService guardUserService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GuardUserVO> saveOrUpdate(@RequestBody GuardUserVO guardUserVO) {
    	return CommonResponse.success("保存或修改单据成功！", guardUserService.insertOrUpdate(guardUserVO));
    }

    @RequestMapping(value = "/updateClose", method = RequestMethod.GET)
    @ResponseBody
    public  CommonResponse<String> updateClose(@RequestParam("id") Long id, @RequestParam("closeStatus") Integer closeStatus) {
        GuardUserEntity guardUser = guardUserService.selectById(id);
        guardUser.setCloseStatus(closeStatus);
        guardUserService.updateById(guardUser);
        return CommonResponse.success("更新启用停用成功");
    }

    @RequestMapping(value = "/deleteById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deleteById(Long id) {
        guardUserService.removeById(id, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GuardUserVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));

        IPage<GuardUserEntity> page = guardUserService.queryPage(param,false);
        IPage<GuardUserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), GuardUserVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
