package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialSpecEntity;
import com.ejianc.business.op.bean.MaterialUnitEntity;
import com.ejianc.business.op.service.IMaterialUnitService;
import com.ejianc.business.op.vo.MaterialUnitVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资单位实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialUnit")
public class MaterialUnitController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialUnitService materialUnitService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialUnitVO> saveOrUpdate(@RequestBody MaterialUnitVO saveOrUpdateVO) {
        LambdaQueryWrapper<MaterialUnitEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialUnitEntity::getOpMaterialId, saveOrUpdateVO.getOpMaterialId());
        queryWrapper.eq(MaterialUnitEntity::getName, saveOrUpdateVO.getName());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), MaterialUnitEntity::getId, saveOrUpdateVO.getId());
        if(materialUnitService.count(queryWrapper) > 0){
            throw new BusinessException("同一分类下单位重复！");
        }
    	MaterialUnitEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialUnitEntity.class);
        materialUnitService.saveOrUpdate(entity, false);
    	MaterialUnitVO vo = BeanMapper.map(entity, MaterialUnitVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialUnitVO> queryDetail(Long id) {
    	MaterialUnitEntity entity = materialUnitService.selectById(id);
    	MaterialUnitVO vo = BeanMapper.map(entity, MaterialUnitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialUnitVO> vos) {
        materialUnitService.removeByIds(vos.stream().map(MaterialUnitVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialUnitVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialUnitEntity> page = materialUnitService.queryPage(param,false);
        IPage<MaterialUnitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialUnitVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
