package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.mapper.ApplyMapper;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.service.IConfigCheckerService;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 申请实体
 *
 * @author generator
 *
 */
@Service("applyService")
public class ApplyServiceImpl extends BaseServiceImpl<ApplyMapper, ApplyEntity> implements IApplyService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "CSCEC5B_OP_APPLY";

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConfigCheckerService configCheckerService;

    @Autowired
    private IGuardUserService guardUserService;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public ApplyVO getBaseInfo(Long orgId, String openid) {
        ApplyEntity apply = new ApplyEntity();
        CommonResponse<OrgVO> response = iOrgApi.getOneById(orgId);
        apply.setParentOrgId(response.getData().getParentId());
        CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(String.valueOf(orgId));
        ProjectRegisterVO projectRegisterVO = commonResponse.getData();
        apply.setOrgId(orgId);
        apply.setProjectId(projectRegisterVO.getId());
        apply.setProjectName(projectRegisterVO.getName());
        apply.setBranchCorpId(projectRegisterVO.getRealCorpId());
        apply.setBranchCorpName(projectRegisterVO.getRealCorpName());

        LambdaQueryWrapper<ApplyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ApplyEntity::getOrgId, orgId);
        queryWrapper.eq(ApplyEntity::getOpenId, openid);
        queryWrapper.orderByDesc(ApplyEntity::getCreateTime);
        List<ApplyEntity> applyList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(applyList)) {
            apply.setApplyUser(applyList.get(0).getApplyUser());
            apply.setApplyDept(applyList.get(0).getApplyDept());
            apply.setTel(applyList.get(0).getTel());
        }
        return BeanMapper.map(apply, ApplyVO.class);
    }

    @Override
    public ApplyVO insertOrUpdate(ApplyVO applyVO) {
        ApplyEntity entity = BeanMapper.map(applyVO, ApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return vo;
    }

    @Override
    public ApplyVO selectDetail(Long id) {
        ApplyEntity applyEntity = selectById(id);
        if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            Integer lasttime = Integer.parseInt(baseMapper.selectCfgUrl("lasttime"));
            Calendar calendar = new GregorianCalendar();
            calendar.setTime(applyEntity.getCheckTime());
            calendar.add(calendar.MINUTE, lasttime);
            if (1 == new Date().compareTo(calendar.getTime())) {
                applyEntity.setOpStatus(OpStatusEnum.EXPIRE.getCode());
                updateById(applyEntity);
            }
        }
        return BeanMapper.map(applyEntity, ApplyVO.class);
    }

    @Override
    public Boolean getPower(ApplyVO applyVO) {
        ApplyEntity applyEntity = selectById(applyVO.getId());
        if (OpStatusEnum.WAIT_CHECK.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper<ConfigCheckerEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ConfigCheckerEntity::getProjectId, applyEntity.getProjectId());
            wrapper.eq(ConfigCheckerEntity::getUserId, InvocationInfoProxy.getUserid());
            return configCheckerService.count(wrapper) > 0;
        } else if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper<GuardUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(GuardUserEntity::getProjectId, applyEntity.getProjectId());
            wrapper.eq(GuardUserEntity::getOpenId, applyVO.getOpenId());
            return guardUserService.count(wrapper) > 0;
        } else {
            throw new BusinessException("该单据状态无扫码结果");
        }
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        String accessroken = "";
        if(null == redisTemplate.opsForValue().get("op_access_token")){
            accessroken = weChatUtil.getAccesstoken();
            if(!StringUtils.isEmpty(accessroken)){
                redisTemplate.opsForValue().set("op_access_token", accessroken, 90, TimeUnit.MINUTES);
            }
            logger.info("获取accessroken:"+accessroken);
        }else{
            accessroken = redisTemplate.opsForValue().get("op_access_token").toString();
            logger.info("获取accessroken:=====" + accessroken);
        }
        String baseAddr = null;
        if (baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        }else if(baseHost.contains("9082")){
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        }else if(baseHost.contains("9080")){
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        ApplyEntity applyEntity = selectById(id);
        //TODO
        String path = "pages/card/card";
        String multipartFile =  weChatUtil.createShortQRCodeStr(path, String.valueOf(id), applyEntity.getBillCode(), accessroken);
        applyEntity.setQrcode(baseAddr + dealImg(multipartFile, applyEntity));
        saveOrUpdate(applyEntity, false);
        return BeanMapper.map(applyEntity, ApplyVO.class);
    }

    @Override
    public List<ApplyReportVO> queryReportPage(Page<ApplyReportVO> page, QueryWrapper wrapper) {
        return baseMapper.queryReportPage(page, wrapper);
    }

    /**
     * 上传图片
     * @return
     */
    private String dealImg(String file, ApplyEntity applyEntity){
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000018");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000018");
        attachmentVO.setFileList(Arrays.asList(file));
        logger.info(JSON.toJSONString(attachmentVO));
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentVO);
        logger.info("图片列表数据前:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return listCommonResponse.getData().get(0).getFilePath();
        }
        return null;
    }
}
