package com.ejianc.business.op.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.op.vo.WechatQRCodeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Component
public class WeChatUtil {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${wechat.mpAppId}")
	private  String mpAppId;

	@Value("${wechat.mpAppSecret}")
	private String mpAppSecret;

	private static final int LONG_CODE_WIDTH = 430;

	private static final int SHORT_CODE_WIDTH = 280;

	/**
	 * 获取openid
	 */
	public Map<String, String> oauth2GetOpenid(String code) {
		//授权（必填）
		String grant_type = "authorization_code";
		//URL
		String requestUrl = "https://api.weixin.qq.com/sns/jscode2session";
		//请求参数
		String params = "appid=" + mpAppId + "&secret=" + mpAppSecret + "&js_code=" + code + "&grant_type=" + grant_type;
		//发送请求
		logger.debug("get openid begin time  is " + new Date());
		String data = HttpUtils.get(requestUrl+"?"+params);
		logger.debug("get openid end time  is " + new Date());
		JSONObject returnJson = JSON.parseObject(data);
		Map<String, String> result = new HashMap<>();
		if(StringUtils.isEmpty(returnJson.getString("openid"))){
			throw new BusinessException("获取openid系统异常，请联系管理员");
		}
		result.put("openid", returnJson.getString("openid"));
		result.put("session_key", returnJson.getString("session_key"));
		result.put("unionid", returnJson.getString("unionid"));
		return result;
	}

	/**
	 *
	 * @Description: 获取access_token并解析
	 * @param
	 *
	 */
	public  String getAccesstoken() {
	    String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid="+ mpAppId + "&secret=" + mpAppSecret;
		logger.info("get accesstoken begin time  is " + new Date());
		String data = HttpUtils.get(url);
		logger.info("get accesstoken url  is " + url);
		logger.info("get accesstoken end time  is " + new Date());
		JSONObject returnJson = JSON.parseObject(data);
		return returnJson.getString("access_token");
	}

	/**
	 *获取小程序二维码
	 *
	 */
	public MultipartFile createLongQRCode(String path, String name, String accessToken) {
		WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
		wechatQRCodeVO.setPath(path);
		wechatQRCodeVO.setWidth(LONG_CODE_WIDTH);
		String url = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + accessToken;
		logger.info("createLongQRCode begin time  is " + new Date());
		InputStream inputStream = HttpUtils.download(url, JSONObject.toJSONString(wechatQRCodeVO));
		logger.info("createLongQRCode end time  is " + new Date());
		try {
			return new MockMultipartFile(name + ".jpeg",name + ".jpeg","image/jpeg", inputStream);
		} catch (IOException e) {
			logger.error(e.getMessage());
		}
		return null;
	}

	/**
	 *获取小程序二维码，返回base64字符串
	 *
	 */
	public String createLongQRCodeStr(String path, String name, String accessToken) {
		WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
		wechatQRCodeVO.setPath(path);
		wechatQRCodeVO.setWidth(LONG_CODE_WIDTH);
		String url = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + accessToken;
		InputStream inputStream = HttpUtils.download(url, JSONObject.toJSONString(wechatQRCodeVO));
		logger.info("createLongQRCode begin time  is " + url);
		logger.info("createLongQRCode end time  is " + JSONObject.toJSONString(wechatQRCodeVO));
		try {
			MultipartFile multipartFile =  new MockMultipartFile(name + ".jpeg",name + ".jpeg","image/jpeg", inputStream);
			String baseStr = null;
			//把MultipartFile转化为File
			File file = new File(multipartFile.getOriginalFilename());
			FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), file);
			//file转base64
			FileInputStream fileInputStream = new FileInputStream(file);
			byte[] buffer = new byte[(int) file.length()];
			fileInputStream.read(buffer);
			fileInputStream.close();
			baseStr = new BASE64Encoder().encode(buffer);
			//删除临时文件
			if (file.exists()) {
				file.delete();
			}
			baseStr = baseStr.replaceAll("\r\n", "");
			return baseStr;
		} catch (IOException e) {
			logger.error(e.getMessage());
		}
		return null;
	}

	/**
	 *获取小程序二维码
	 *
	 */
	public MultipartFile createShortQRCode(String page, String scene, String name, String accessToken) {
		WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
		wechatQRCodeVO.setPage(page);
		wechatQRCodeVO.setScene(scene);
		wechatQRCodeVO.setWidth(SHORT_CODE_WIDTH);
		String url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + accessToken;
		logger.info("createShortQRCode begin time  is " + new Date());
		InputStream inputStream = HttpUtils.download(url, JSONObject.toJSONString(wechatQRCodeVO));
		logger.info("createShortQRCode end time  is " + new Date());
		try {
			return new MockMultipartFile(name + ".jpeg",name + ".jpeg","image/jpeg", inputStream);
		} catch (IOException e) {
			logger.error(e.getMessage());
		}
		return null;
	}

	/**
	 *获取小程序无限制二维码,返回base64字符串
	 *
	 */
	public String createShortQRCodeStr(String page, String scene, String name, String accessToken) {
		WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
		wechatQRCodeVO.setPage(page);
		wechatQRCodeVO.setScene(scene);
		wechatQRCodeVO.setWidth(SHORT_CODE_WIDTH);
		String url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + accessToken;
		logger.info("createShortQRCode begin time  is " + new Date());
		InputStream inputStream = HttpUtils.download(url, JSONObject.toJSONString(wechatQRCodeVO));
		logger.info("createShortQRCode end time  is " + new Date());
		try {
			MultipartFile multipartFile =  new MockMultipartFile(name + ".jpeg",name + ".jpeg","image/jpeg", inputStream);
			String baseStr = null;
			//把MultipartFile转化为File
			File file = new File(multipartFile.getOriginalFilename());
			FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), file);
			//file转base64
			FileInputStream fileInputStream = new FileInputStream(file);
			byte[] buffer = new byte[(int) file.length()];
			fileInputStream.read(buffer);
			fileInputStream.close();
			baseStr = new BASE64Encoder().encode(buffer);
			//删除临时文件
			if (file.exists()) {
				file.delete();
			}
			baseStr = baseStr.replaceAll("\r\n", "");
			return baseStr;
		} catch (IOException e) {
			logger.error(e.getMessage());
		}
		return null;
	}
}
