package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialSpecEntity;
import com.ejianc.business.op.service.IMaterialSpecService;
import com.ejianc.business.op.vo.MaterialSpecVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资规格实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialSpec")
public class MaterialSpecController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialSpecService materialSpecService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialSpecVO> saveOrUpdate(@RequestBody MaterialSpecVO saveOrUpdateVO) {
        LambdaQueryWrapper<MaterialSpecEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialSpecEntity::getOpMaterialId, saveOrUpdateVO.getOpMaterialId());
        queryWrapper.eq(MaterialSpecEntity::getSpec, saveOrUpdateVO.getSpec());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), MaterialSpecEntity::getId, saveOrUpdateVO.getId());
        if(materialSpecService.count(queryWrapper) > 0){
            throw new BusinessException("同一分类下规格型号重复！");
        }
        MaterialSpecEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialSpecEntity.class);
        materialSpecService.saveOrUpdate(entity, false);
        MaterialSpecVO vo = BeanMapper.map(entity,  MaterialSpecVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialSpecVO> queryDetail(Long id) {
    	 MaterialSpecEntity entity = materialSpecService.selectById(id);
    	 MaterialSpecVO vo = BeanMapper.map(entity,  MaterialSpecVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialSpecVO> vos) {
        materialSpecService.removeByIds(vos.stream().map(MaterialSpecVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialSpecVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage< MaterialSpecEntity> page = materialSpecService.queryPage(param,false);
        IPage< MaterialSpecVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialSpecVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
