package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.op.mapper.ConfigMapper;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.service.IConfigService;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 配置实体
 *
 * @author generator
 *
 */
@Service("configService")
public class ConfigServiceImpl extends BaseServiceImpl<ConfigMapper, ConfigEntity> implements IConfigService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProjectApi projectApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public ConfigVO createQRCode(Long orgId) {
        CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(String.valueOf(orgId));
        String accessroken = "";
        if(null == redisTemplate.opsForValue().get("op_access_token")){
            accessroken = weChatUtil.getAccesstoken();
            if(!StringUtils.isEmpty(accessroken)){
                redisTemplate.opsForValue().set("op_access_token", accessroken, 90, TimeUnit.MINUTES);
            }
            logger.info("获取accessroken:"+accessroken);
        }else{
            accessroken = redisTemplate.opsForValue().get("op_access_token").toString();
            logger.info("获取accessroken:=====" + accessroken);
        }
        String baseAddr = null;
        if (baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        }else if(baseHost.contains("9082")){
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        }else if(baseHost.contains("9080")){
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        ConfigEntity config = new ConfigEntity();
        config.setId(IdWorker.getId());
        config.setProjectId(commonResponse.getData().getId());
        config.setOrgId(orgId);
        config.setCloseStatus(BooleanStatusEnum.否.getCode());
        config.setGuardStatus(BooleanStatusEnum.否.getCode());
        config.setPhotoStatus(BooleanStatusEnum.否.getCode());
        String path = "permit/card?orgId=" + orgId;
        String multipartFile =  weChatUtil.createLongQRCodeStr(path, String.valueOf(orgId), accessroken);
        config.setQrcode(baseAddr + dealImg(multipartFile, config));
        saveOrUpdate(config, false);
        return BeanMapper.map(config, ConfigVO.class);
    }

    /**
     * 上传图片
     * @return
     */
    private String dealImg(String file, ConfigEntity configEntity){
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000017");
        attachmentVO.setSourceId(String.valueOf(configEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000017");
        attachmentVO.setFileList(Arrays.asList(file));
        logger.info(JSON.toJSONString(attachmentVO));
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentVO);
        logger.info("图片列表数据前:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return listCommonResponse.getData().get(0).getFilePath();
        }
        return null;
    }
}
