package com.ejianc.business.op.util;

import com.ejianc.foundation.usercenter.vo.UserVO;
import org.apache.commons.lang.StringUtils;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

import java.text.ParseException;

public class PasswordUtils {

    public static final int HASH_INTERATIONS = 1;
    private static final int SALT_SIZE = 8;

    public static String encodebyUserCode(UserVO user) {
        String userCode = user.getUserCode();
        if (StringUtils.isNotBlank(userCode)) {
            String hashUserCode = encodePasswordUsingSHA(userCode);
            byte[] hashPassword = Digests.sha1(
                    (user.getPassword() + hashUserCode).getBytes(),
                    Encodes.decodeHex(user.getSalt()), HASH_INTERATIONS);

            return Encodes.encodeHex(hashPassword);
        }
        byte[] hashPassword = Digests.sha1(user.getPassword().getBytes(),
                Encodes.decodeHex(user.getSalt()), HASH_INTERATIONS);

        return Encodes.encodeHex(hashPassword);
    }

    public static void setSalt(UserVO user) {
        byte[] salt = Digests.generateSalt(SALT_SIZE);
        user.setSalt(Encodes.encodeHex(salt));
    }

    public static String encodePassword(String password, String salt) {
        byte[] hashPassword = Digests.sha1(password.getBytes(),
                Encodes.decodeHex(salt), HASH_INTERATIONS);
        return Encodes.encodeHex(hashPassword);
    }

    public static String encodePasswordByUserCode(String password, String salt,
                                                  String userCode) {
        if (StringUtils.isNotBlank(userCode)) {
            String hashUserCode = encodePasswordUsingSHA(userCode);
            byte[] hashPassword = Digests.sha1(
                    (password + hashUserCode).getBytes(),
                    Encodes.decodeHex(salt), HASH_INTERATIONS);

            return Encodes.encodeHex(hashPassword);
        }
        byte[] hashPassword = Digests.sha1(password.getBytes(),
                Encodes.decodeHex(salt), HASH_INTERATIONS);
        return Encodes.encodeHex(hashPassword);
    }

    public static String encodePasswordUsingSHA(String password) {
        byte[] hashPassword = Digests.sha1(password.getBytes());
        String result = Encodes.encodeHex(hashPassword);
        return result;
    }

    public static String encodePasswordUsingSHA(String password, String salt) {
        byte[] hashPassword = Digests.sha1(password.getBytes());
        String shaResult = Encodes.encodeHex(hashPassword);
        byte[] encrytyPassword = Digests.sha1(shaResult.getBytes(),
                Encodes.decodeHex(salt), HASH_INTERATIONS);
        return Encodes.encodeHex(encrytyPassword);
    }

    public static String getSalt() {
        byte[] salt = Digests.generateSalt(SALT_SIZE);
        return Encodes.encodeHex(salt);
    }
    public static void main(String[] args) throws ParseException {
        String salt ="49ba97d3d32d092a";//盐值
        //PasswordUtils.getSalt();
        String shaPassword =PasswordUtils.encodePasswordUsingSHA("adminzzyj2021"); //密码
        String password =PasswordUtils.encodePasswordByUserCode(shaPassword,salt,"adminzzyj");
//        System.out.println("salt："+salt);
        System.out.println("密码："+password);
//
//
//        System.out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2050-01-01 00:00:00").getTime());


//        System.out.println(PasswordUtils.encodePasswordByUserCode("8bb1e26cbd9503d776e5e578cb7ab436d677ce52", "49ba97d3d32d092a", "guoming"));
    }

}
