/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.util.TemplateDatas;
import com.ejianc.business.op.util.TemplateMsgApi;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.jfinal.weixin.sdk.api.ApiResult;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="apply")
public class ApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApplyService applyService;
    @Value(value="${wechat.tmpId}")
    private String tmpId;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private WeChatUtil weChatUtil;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeSubmitProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterSubmitProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        applyEntity.setOpStatus(OpStatusEnum.APPROVING.getCode());
        this.applyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeHasBpmBack billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterHasBpmBack billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        applyEntity.setOpStatus(OpStatusEnum.REFUSE.getCode());
        this.applyService.saveOrUpdate((Object)applyEntity);
        this.sendWxMsg(billId, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        this.logger.info("beforeInApprovalBack billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeApprovalProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.applyService.createQRCode(billId);
        this.sendWxMsg(billId, true);
        return CommonResponse.success();
    }

    private void sendWxMsg(Long billId, Boolean isPass) {
        String openid;
        ApplyEntity entity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        String accessroken = null;
        if (null == this.redisTemplate.opsForValue().get((Object)"op_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"op_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.info("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"op_access_token").toString();
            this.logger.info("\u83b7\u53d6accessroken:=====" + accessroken);
        }
        if (!StringUtils.isEmpty((CharSequence)accessroken) && StringUtils.isNotEmpty((CharSequence)(openid = entity.getOpenId()))) {
            String path = "pages/index/index";
            this.logger.error("pagepath:" + path);
            String json = TemplateDatas.New().setTouser(openid).setTemplate_id(this.tmpId).setPage(path).setMiniprogram_state("formal").add("character_string19", entity.getBillCode(), "#743A3A").add("phrase5", isPass != false ? "\u901a\u8fc7" : "\u9a73\u56de", "#743A3A").add("thing4", "\u7533\u8bf7\u5355\u5ba1\u6838\u5b8c\u6210\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", "#0000FF").build();
            this.logger.debug("\u53d1\u9001\u6d88\u606f\u4fe1\u606f\uff1a" + json);
            ApiResult result = TemplateMsgApi.send(accessroken, json);
            this.logger.debug("\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u8fd4\u56de\u7ed3\u679c+" + result.getJson());
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeAbstainingProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        applyEntity.setOpStatus(OpStatusEnum.SAVE.getCode());
        this.applyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterAbstainingProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }
}

