package com.ejianc.business.panhuo.api;

import com.ejianc.business.panhuo.hystrix.GoodsHystrix;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.QueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 *
 * @author yqls
 *
 */
@FeignClient(name= "cscec5b-panhuo-web", url="${common.env.feign-client-url}", path="cscec5b-panhuo-web", fallback = GoodsHystrix.class)
public interface IGoodsApi {

	/**
	 * 根据组织和物资集合查询同一调拨管理组织下数据
	 *
	 * @param queryVO
	 * @return
	 */
	@PostMapping(value = "/api/goods/queryGoodsByOrgMat")
	CommonResponse<List<GoodsVO>> queryGoodsByOrgMat(@RequestBody QueryVO queryVO);

}
