package com.ejianc.business.panhuo.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 批量订单主实体
 *
 * @author generator
 *
 */
 @TableName("ejc_panhuo_order_batch")
public class OrderBatchEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="code")
    private String code; // 项目编号
    @TableField(value="name")
    private String name; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="bill_code")
    private String billCode; // 订单编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="user_name")
    private String userName; //联系人
    @TableField(value="user_phone")
    private String userPhone; // 联系电话
    @TableField(value="sum_mny")
    private BigDecimal sumMny; // 总金额

    @TableField(exist=false)
    @SubEntity(serviceName="orderBatchDetailService",pidName = "batchId")
    private List<OrderBatchDetailEntity> orderBatchDetailList = new ArrayList<>(); // 子表实体



    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }

    public List<OrderBatchDetailEntity> getOrderBatchDetailList() {
        return orderBatchDetailList;
    }

    public void setOrderBatchDetailList(List<OrderBatchDetailEntity> orderBatchDetailList) {
        this.orderBatchDetailList = orderBatchDetailList;
    }
}
