package com.ejianc.business.panhuo.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 批量上架子实体
 *
 * @author generator
 *
 */
 @TableName("ejc_panhuo_shelf_batch_detail")
public class ShelfBatchDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="shelf_id")
    private Long shelfId; // 主表主键
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="bill_code")
    private String billCode; // 资产编号
    @TableField(value="bill_name")
    private String billName; // 资产名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="price")
    private BigDecimal price; // 采购单价
    @TableField(value="discount")
    private BigDecimal discount; // 折扣
    @TableField(value="shelf_price")
    private BigDecimal shelfPrice; // 上架单价
    @TableField(value="rotatable_nums")
    private BigDecimal rotatableNums; // 可周转数量(上架-已成交-预定中)
    @TableField(value="tax")
    private java.math.BigDecimal tax; // 增值税税率
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 增值税税额
    @TableField(value="shelf_mny")
    private BigDecimal shelfMny; // 上架总金额
    @TableField(value="is_pack")
    private String isPack; // 是否打包出售 0-是  1-否
    @TableField(value="mainimg_path")
    private String mainimgPath; // 资产主图URL
    @TableField(value="label_name")
    private String labelName; // 标签名称
    @TableField(value="details")
    private String details; // 资产详情
    @TableField(value="pre_sale_flag")
    private Boolean preSaleFlag;//是否预售
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="pre_sale_date")
    private Date preSaleDate; // 预售日期
    @TableField(value="on_shelf_type")
    private Integer onShelfType; // 上架类型：0-正常上架 1-预售上架
    @TableField(value="shelf_type")
    private java.lang.String shelfType; // 资产类型
    @TableField(value="material_id")
    private java.lang.Long materialId; // 物资主键
    @TableField(value="material_code")
    private java.lang.String materialCode; // 物资编号
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="material_type_id")
    private java.lang.Long materialTypeId; // 物资类别
    @TableField(value="material_type_name")
    private java.lang.String materialTypeName; // 物资类别名称
    @TableField(value="is_batch")
    private String isBatch; // 是否批量上架 0-是  1-否
    @TableField(value="fileIds")
    private String fileIds; //图片主键集合



    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }
    public BigDecimal getShelfPrice() {
        return shelfPrice;
    }

    public void setShelfPrice(BigDecimal shelfPrice) {
        this.shelfPrice = shelfPrice;
    }
    public BigDecimal getRotatableNums() {
        return rotatableNums;
    }

    /**
     * 增值税税率
     */
    public void setTax(BigDecimal tax) {this.tax = tax;}
    public BigDecimal getTax() {return tax;}

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }


    public void setRotatableNums(BigDecimal rotatableNums) {
        this.rotatableNums = rotatableNums;
    }
    public BigDecimal getShelfMny() {
        return shelfMny;
    }

    public void setShelfMny(BigDecimal shelfMny) {
        this.shelfMny = shelfMny;
    }

    public String getIsPack() {
        return isPack;
    }

    public void setIsPack(String isPack) {
        this.isPack = isPack;
    }

    public String getMainimgPath() {
        return mainimgPath;
    }

    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    public String getLabelName() {
        return labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }
    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Boolean getPreSaleFlag() {
        return preSaleFlag;
    }

    public void setPreSaleFlag(Boolean preSaleFlag) {
        this.preSaleFlag = preSaleFlag;
    }

    public Date getPreSaleDate() {
        return preSaleDate;
    }

    public void setPreSaleDate(Date preSaleDate) {
        this.preSaleDate = preSaleDate;
    }
    public Integer getOnShelfType() {
        return onShelfType;
    }

    public void setOnShelfType(Integer onShelfType) {
        this.onShelfType = onShelfType;
    }

    public Long getShelfId() {
        return shelfId;
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public String getShelfType() {
        return shelfType;
    }

    public void setShelfType(String shelfType) {
        this.shelfType = shelfType;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getIsBatch() {
        return isBatch;
    }

    public void setIsBatch(String isBatch) {
        this.isBatch = isBatch;
    }

    public String getFileIds() {
        return fileIds;
    }

    public void setFileIds(String fileIds) {
        this.fileIds = fileIds;
    }
}
