package com.ejianc.business.panhuo.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 调拨单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("allot")
public class AllotController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAllotService service;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotVO> saveOrUpdate(@RequestBody AllotVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！",service.saveAllot(saveorUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllotVO> queryDetail(Long id) {
    	AllotEntity entity = service.selectById(id);
        entity.setParentBuyOrgSource(getSourceOrgId(entity.getParentBuyOrg()));
        entity.setParentSellOrgSource(getSourceOrgId(entity.getParentSellOrg()));
        AllotVO vo = BeanMapper.map(entity, AllotVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotVO> vos) {
        service.removeByIds(vos.stream().map(AllotVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AllotVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前用户所属组织下的所有项目主键
        setOrgParam(param);

        IPage<AllotEntity> page = service.queryPage(param,false);
        IPage<AllotVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void setOrgParam(QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                ComplexParam c1 = new ComplexParam();
                c1.setLogic(ComplexParam.AND);

                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("sellOrg", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c2);


                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("buyOrg", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c3);

                param.getComplexParams().add(c1);
            } else {
                param.getComplexParams().add(getPageQueryParamPC());
            }

        } else {
            param.getComplexParams().add(getPageQueryParamMobile());
        }
    }

    public ComplexParam getPageQueryParamPC() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("parentSellOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);


        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("parentBuyOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);

        return c1;
    }

    private String getSourceOrgId(Long orgId){
        CommonResponse<OrgVO> orgVo = orgApi.detailById(orgId);

        if(!orgVo.isSuccess()) {
            throw new BusinessException("查询组织信息失败,请稍后重试！");
        }else{
            return orgVo.getData().getSourceId();
        }
    }
    public ComplexParam getPageQueryParamMobile() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);


        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);

        return c1;
    }

    /**
     * @Description queryLastVOByOrg 根据调入调出项目查询历史信息
     * @param
     * @return
     */
    @RequestMapping(value = "/queryLastVOByOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllotVO> queryLastVOByOrg(Long sellProject,Long buyProject) {
        List<AllotEntity> details = null;
        LambdaQueryWrapper<AllotEntity> lambda = Wrappers.<AllotEntity>lambdaQuery();
        lambda.eq(AllotEntity::getTenantId, InvocationInfoProxy.getTenantid());//租户
        if( sellProject!= null){
            lambda.eq(AllotEntity::getSellProject, sellProject);
        }
        if( buyProject!= null){
            lambda.eq(AllotEntity::getBuyProject, buyProject);
        }
        lambda.orderByDesc(AllotEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            if(sellProject!= null && details.get(0).getCkcorgidSell() != null &&  details.get(0).getCwarehouseidSell() != null){
                return CommonResponse.success("查询详情数据成功！",BeanMapper.map(details.get(0), AllotVO.class));
            }
            if(buyProject!= null && details.get(0).getCkcorgidBuy() != null &&  details.get(0).getCwarehouseidBuy() != null){
                return CommonResponse.success("查询详情数据成功！",BeanMapper.map(details.get(0), AllotVO.class));
            }else{
                return CommonResponse.success("查询详情数据成功！", null);
            }
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        setOrgParam(param);

        IPage<AllotEntity> page = service.queryPage(param,false);
        IPage<AllotVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotVO.class));

        List<AllotVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("allotExport.xlsx", beans, response);
    }

    /**
     * 批量生成调拨单
     * @return
     */
    @RequestMapping(value = "/generation", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> generation(HttpServletRequest request) {
        logger.info("调拨定时任务进入成功");
        String generateDate = request.getParameter("generateDate");
        logger.info("generateDate参数为："+generateDate);
        service.generation(generateDate);
        return CommonResponse.success("调拨单批量生成成功！");
    }

    /**
     * 定制批量生成调拨单
     * 指定组织、指定调拨开始日期结束日期
     * @return
     */
    @RequestMapping(value = "/customerGeneration", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> customerGeneration(HttpServletRequest request) {
        String beginDate = request.getParameter("beginDate");
        String endDate = request.getParameter("endDate");
        String orgId = request.getParameter("orgId");

        service.customerGeneration(beginDate,endDate,orgId);
        return CommonResponse.success("调拨单批量生成成功！");
    }

   /* @RequestMapping(value = "/allotIsflag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> allotIsflag(String beginDate,String endDate,String orgId) {
        service.allotIsflag(beginDate,endDate,orgId);
        return CommonResponse.success("调拨单批量生成成功！");
    }*/
}
