package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AllotDetailEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IAllotDetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.AllotDetailVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 调拨单明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("allotDetail")
public class AllotDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IAllotDetailService service;

    @Autowired
    private IOrderService orderService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotDetailVO> saveOrUpdate(@RequestBody AllotDetailVO saveorUpdateVO) {
    	AllotDetailEntity entity = BeanMapper.map(saveorUpdateVO, AllotDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	AllotDetailVO vo = BeanMapper.map(entity, AllotDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllotDetailVO> queryDetail(Long id) {
    	AllotDetailEntity entity = service.selectById(id);
    	AllotDetailVO vo = BeanMapper.map(entity, AllotDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotDetailVO> vos) {
        service.removeByIds(vos.stream().map(AllotDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前用户所属组织下的所有项目主键
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));
        setOrgParam(param);

        IPage<OrderEntity> page = orderService.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        List<Long> orderIdList = null;
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            orderIdList = pageData.getRecords().stream().map(OrderVO::getId).collect(Collectors.toList());
        }
        List<OrderVO> result = service.getAllotInfo(orderIdList);
        if (CollectionUtils.isNotEmpty(result)) {
            Map<Long, OrderVO> map = result.stream().collect(Collectors.toMap(OrderVO::getId, Function.identity(), (key1, key2) -> key1));
            for(OrderVO orderVO : pageData.getRecords()){
                if (map.containsKey(orderVO.getId())) {
                    OrderVO order = map.get(orderVO.getId());
                    orderVO.setAllotCode(order.getBillCode());
                    orderVO.setAllotTime(order.getDealrTime());
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    private void setOrgParam(QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                ComplexParam c1 = new ComplexParam();
                c1.setLogic(ComplexParam.AND);

                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("sellOrg", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c2);


                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("buyOrg", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c3);

                param.getComplexParams().add(c1);
            } else {
                param.getComplexParams().add(getPageQueryParamPC());
            }

        } else {
            param.getComplexParams().add(getPageQueryParamMobile());
        }
    }

    public ComplexParam getPageQueryParamPC() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("parentSellOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);


        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("parentBuyOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);

        return c1;
    }

    public ComplexParam getPageQueryParamMobile() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);


        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);

        return c1;
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<OrderVO>> iPageCommonResponse = this.queryList(param);
        List<OrderVO> list = new ArrayList<>();
        if (iPageCommonResponse.getData() != null) {
            list = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AllotDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAllotDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AllotDetailVO>> refAllotDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AllotDetailEntity> page = service.queryPage(param,false);
        IPage<AllotDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
