package com.ejianc.business.panhuo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.ConfigEntity;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.vo.ConfigVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 调拨管理组织实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("config")
public class ConfigController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IConfigService service;

    @Autowired
    private IOrgApi orgApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConfigVO> saveOrUpdate(@RequestBody ConfigVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId() && StringUtils.isBlank(saveorUpdateVO.getOrgCreateDate())) {
            saveorUpdateVO.setOrgCreateDate("21");
        }else{
            ConfigEntity configEntity = service.selectById(saveorUpdateVO.getId());
            System.out.println("saveorUpdateVO.getId() ==>"+ saveorUpdateVO.getId());
            logger.error("saveorUpdateVO.getId() ==>"+ saveorUpdateVO.getId());
            logger.error("saveorUpdateVO.orgId() ==>"+ saveorUpdateVO.getOrgId());
            logger.error("saveorUpdateVO.orgName() ==>"+ saveorUpdateVO.getOrgName());
            Integer date = 32;
            if ( !saveorUpdateVO.getOrgCreateDate().contains("最后一天") ) {
                List<String> createDateList = Arrays.asList(saveorUpdateVO.getOrgCreateDate().split(","));
                date = Integer.parseInt(Collections.max(createDateList));
            }
            System.out.println("saveorUpdateVO.getOrgCreateDate() ==>"+ saveorUpdateVO.getOrgCreateDate());
            logger.error("saveorUpdateVO.getOrgCreateDate() ==>"+ saveorUpdateVO.getOrgCreateDate());
            Integer nowDay = Integer.parseInt(DateFormatUtils.format(new Date(), "dd"));
            if((null == configEntity.getOrgAllotStatus() || !configEntity.getOrgAllotStatus()) && saveorUpdateVO.getOrgAllotStatus()){
                if (!configEntity.getOrgCreateDate().contains("最后一天") && date < nowDay) {
                    throw new BusinessException("启用后，本调拨组织生成日期小于当前日期，本月将不能生成调拨单!");
                }
            }else if(configEntity.getOrgAllotStatus() && !saveorUpdateVO.getOrgAllotStatus()){
                ConfigEntity config = queryConfigByOrgId(saveorUpdateVO.getOrgId());
                if (!configEntity.getOrgCreateDate().contains("最后一天") && date < nowDay) {
                    throw new BusinessException("停用后，最近调拨组织生成日期小于当前日期，本组织本月将不能生成调拨单!");
                }
            }else if (configEntity.getOrgAllotStatus() && !configEntity.getOrgCreateDate().contains("最后一天") && date < nowDay) {
                throw new BusinessException("修改后，本调拨组织生成日期小于当前日期，本月将不能生成调拨单!");
            }
        }
        ConfigEntity entity = BeanMapper.map(saveorUpdateVO, ConfigEntity.class);
        service.saveOrUpdate(entity, false);
        ConfigVO vo = BeanMapper.map(entity, ConfigVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    private ConfigEntity queryConfigByOrgId(Long orgId) {
        CommonResponse<OrgVO> sellOrg = orgApi.getOneById(orgId);
        if(!sellOrg.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        QueryParam queryParam = new QueryParam();
        //查询所有配置为调拨管理组织的集团、分公司信息
        queryParam.getParams().put("orgAllotStatus",new Parameter(QueryParam.EQ,"1"));
        List<ConfigEntity> configEntityList = service.queryList(queryParam);
        Map<String, ConfigEntity> configMap = new HashMap<>();
        for(ConfigEntity configEntity:configEntityList){
            configMap.put(String.valueOf(configEntity.getOrgId()), configEntity);
        }

        String innerCode = sellOrg.getData().getInnerCode();//调出组织内码
        String[] sellParentIdList = innerCode.contains("|")?innerCode.split("\\|"): new String[]{innerCode};
        String sellConfigOrgId = "";
        for(int i=sellParentIdList.length-1;i>=0;i--){
            String sellParentId = sellParentIdList[i];
            if (!sellParentId.equals(String.valueOf(orgId)) && configMap.containsKey(sellParentId)) {
                sellConfigOrgId = sellParentId;
                break;
            }
        }
        return configMap.get(sellConfigOrgId);
    }

    /**
     * @param orgId
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetail(Long orgId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        List<ConfigEntity> list = service.queryList(queryParam, false);
        ConfigVO vo = new ConfigVO();
        if (CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), ConfigVO.class);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description queryDate 查询日期
     * @param orgId
     */
    @RequestMapping(value = "/queryDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDate(Long  orgId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        List<ConfigEntity> list = service.queryList(queryParam, false);
        ConfigVO vo = new ConfigVO();
        if (CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), ConfigVO.class);
        }
        return CommonResponse.success("查询详情数据成功！", vo.getOrgCreateDate());
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConfigVO> vos) {
        service.removeByIds(vos.stream().map(ConfigVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConfigVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ConfigEntity> page = service.queryPage(param, false);
        IPage<ConfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConfigVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }
}


