package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.util.IPUtils;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.support.idworker.util.IdWorker;
import com.maxmind.geoip2.DatabaseReader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 资产表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("goods")
public class GoodsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IGoodsService service;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IConfigService configService;

    @Autowired
    private IWbuyService wbuyService;

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdate(@RequestBody GoodsVO saveorUpdateVO) {
    	return CommonResponse.success("操作成功！",service.saveGoods(saveorUpdateVO));
    }

    /**
     * @Description updateMainimgPath 修改主图
     */
    @RequestMapping(value = "/updateMainimgPath", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateMainimgPath(@RequestBody GoodsVO saveorUpdateVO) {
        LambdaUpdateWrapper<GoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(GoodsEntity::getId,saveorUpdateVO.getId());
        updateWrapper.set(GoodsEntity::getMainimgPath,saveorUpdateVO.getMainimgPath());
        service.update(updateWrapper);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
    	GoodsEntity entity = service.selectById(id);
    	GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 复制上架
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryCopyDetail(Long id) {
        GoodsEntity entity = service.selectById(id);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
//        vo.setId(null);
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setToolId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setRotatableNums(entity.getNums());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRotatableNums(entity.getNums());

//        if(CollectionUtils.isNotEmpty(vo.getImgsPath())){
//            vo.getImgsPath().forEach(e -> {
//                e.setSourceId(null);
//                e.setRowState("add");
//            });
//        }
        vo.setId(IdWorker.getId());
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                id.toString(),
                "BT211111000000004",
                "imgUpload",
                vo.getId().toString(),
                "BT211111000000004",
                "imgUpload"
                );
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        if(CollectionUtils.isNotEmpty(vo.getLabels())){
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
        lambdachange.eq(OrderEntity::getGoodsId, vos.get(0).getId());
        List<OrderEntity> list = orderService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("该商品存在订单,不允许删除");
        }
        service.removeByIds(vos.stream().map(GoodsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(HttpServletRequest request,@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter materialName = param.getParams().get("materialName");
        Parameter spec = param.getParams().get("spec");
        Parameter corpId = param.getParams().get("corpId");
        param.getParams().remove("corpId");
        if(materialName != null){
            param.getParams().put("materialName", new Parameter(QueryParam.EQ, materialName.getValue()));
        }
        if(spec != null){
            param.getParams().put("spec", new Parameter(QueryParam.EQ, spec.getValue()));
        }
        //组织隔离
       // logger.error("ss" + InvocationInfoProxy.getOrgId());
        String configOrgId = configService.queryConfigOrgByOrgId(InvocationInfoProxy.getOrgId());
       // logger.error("ss" + configOrgId);
        if(StringUtils.isBlank(configOrgId)){
            Page<GoodsEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
            res.put("records", null);
            res.put("total", page.getTotal());
            res.put("current", page.getCurrent());
            res.put("size", page.getSize());
            res.put("pages", page.getPages());
            return CommonResponse.success("查询列表数据成功！",res);
        }else{
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(Long.valueOf(configOrgId));
          //  logger.error("ss" + JSONObject.toJSONString(childOrgResp));
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> orgList1 = new ArrayList<>();
            List<Long> orgList2 = new ArrayList<>();
            orgList1 = childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            // 查询出售单位
            if(corpId != null){
                CommonResponse<List<OrgVO>> childOrgResp2 = orgApi.findChildrenByParentId(Long.valueOf(corpId.getValue().toString()));
                if(!childOrgResp2.isSuccess()) {
                    throw new BusinessException("查询组织信息失败！");
                }
                if( CollectionUtils.isNotEmpty(childOrgResp2.getData()) && CollectionUtils.isNotEmpty(childOrgResp.getData()) ) {
                    orgList2 = childOrgResp2.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                    orgList1.retainAll(orgList2);
                    logger.info("----- orgList1.size：" + orgList1.size() + "----- orgList2.size：" + orgList2.size());
                } else {
                    return CommonResponse.success("查询列表数据成功！",null);
                }
            }
            if(CollectionUtils.isNotEmpty(orgList1)){
                List<Long> childIds = new ArrayList<>();
                childIds.addAll(orgList1);
                param.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));

                Parameter isSupplyDemand = param.getParams().get("isSupplyDemand");
                if (null != isSupplyDemand && null != isSupplyDemand.getValue() && 1 == Integer.parseInt((String) isSupplyDemand.getValue())) {
                    List<Long> categoryList = wbuyService.queryCtyIdsByOrgs(childIds);
                    param.getParams().put("material_type_id", new Parameter(QueryParam.IN, categoryList));
                    param.getParams().remove("isSupplyDemand");
                }
            } else {
                return CommonResponse.success("查询列表数据成功！",null);
            }
        }
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
        Parameter lon = param.getParams().get("lon");
        Parameter lat = param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        String lonValue = "";
        String LatValue = "";
        if(null!=lon&&null!=lat){
            lonValue = lon.getValue() + "";
            LatValue = lat.getValue() + "";
        }else{
            ClassPathResource resource = new ClassPathResource("GeoLite2-City_20210420/GeoLite2-City.mmdb");
            logger.info("-----"+resource);
            // 创建 GeoLite2 数据库
            // 读取数据库内容
            DatabaseReader reader = null;
            try {
                reader = new DatabaseReader.Builder(resource.getInputStream()).build();
            } catch (IOException e) {
                e.printStackTrace();
            }
            logger.info("******"+reader);
            // 访问IP
            String ip = IPUtils.getIP(request).split(",")[0];
            logger.info("******ip"+ip);
            if("127.0.0.1".equals(ip)){
                ip = "115.60.183.195";
            }
            try {
                lonValue = IPUtils.getLongitude(reader, ip).toString();
                LatValue = IPUtils.getLatitude(reader, ip).toString();
            } catch (Exception e) {
                ip = "115.60.183.195";
                try {
                    lonValue = IPUtils.getLongitude(reader, ip).toString();
                    LatValue = IPUtils.getLatitude(reader, ip).toString();
                } catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        Parameter distance = param.getParams().get("distance");
        if (null != distance && !"-1".equals(distance.getValue())) {
            param.getParams().put("distance", new Parameter(QueryParam.LE, ComputeUtil.safeMultiply(BigDecimal.valueOf(1000), BigDecimal.valueOf(Integer.parseInt((String)distance.getValue())))));
        }else{
            param.getParams().remove("distance");
        }


        Page<GoodsEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<GoodsEntity> list = service.queryGoods(page,wrapper,lonValue,LatValue);
        res.put("records", BeanMapper.mapList(list,GoodsVO.class));
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

    /**
     * @Description queryGoodsDetail  资产集市-查询详情(带周转记录，其他项目等信息)
     * @param id
     */
    @RequestMapping(value = "/queryGoodsDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsDetailsVO> queryGoodsDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryGoodsDetail(id));
    }

    /**
     * @Description queryGoodsDetail  资产详情 - 卖家所有在售信息
     * @param
     */
    @RequestMapping(value = "/queryOtherGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryOtherGoods(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("spec");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));
        return CommonResponse.success("查询数据成功！",pageData);
    }

    /**
     * @Description queryList 我的货架-出售中
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("orgId", param);

        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 我的货架-已下架
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 1));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("orgId", param);

        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 我的货架-暂存
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsTemp(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("orgId", param);
        IPage<GoodsEntity> page = service.queryPage(param,false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description updateStatus 下架
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> updateStatus(@RequestBody GoodsVO saveorUpdateVO) {
        GoodsEntity entity = service.selectById(saveorUpdateVO.getId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ,saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
        List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
        if(null!=listOrder&&listOrder.size()>0){
            return  CommonResponse.error(5001,"存在未完成的订单,不允许下架！");
        }
        entity.setStatus(1);//下架
        entity.setLowerType(0);//下架类型0-手动下架，1-售罄下架，2-到期下架
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());
        service.saveOrUpdate(entity, false);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("操作成功！",vo);
    }

    /**
     * @Description batchUpdateStatus 批量下架
     */
    @RequestMapping(value = "/batchUpdateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<GoodsVO>> batchUpdateStatus(@RequestBody List<GoodsVO> vos) {
        List<GoodsVO> goodsVOList = new ArrayList<>();
        for(GoodsVO goodsVO : vos) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ, goodsVO.getId()));
            queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 0));
            //查询是否有订单如果有把这条信息返回给前端方便展示
            List<OrderEntity> listOrder = orderService.queryList(queryParam, false);
            if (null != listOrder && listOrder.size() > 0) {
                GoodsEntity entity = service.selectById(goodsVO.getId());
                GoodsVO vo = new GoodsVO();
                vo.setId(entity.getId());
                vo.setBillCode(entity.getBillCode());
                vo.setMaterialName(entity.getMaterialName());
                goodsVOList.add(vo);
            }
        }
        if(CollectionUtils.isEmpty(goodsVOList)){
            for(GoodsVO goodsVO : vos){
                GoodsEntity entity = service.selectById(goodsVO.getId());
                entity.setStatus(1);//下架
                entity.setLowerType(0);//下架类型0-手动下架，1-售罄下架，2-到期下架
                entity.setLower(InvocationInfoProxy.getUserid());
                entity.setLowerTime(DateFormater.getCurrentDate());
                service.saveOrUpdate(entity, false);
            }
            return CommonResponse.success("下架成功！",goodsVOList);
        }else{
            return CommonResponse.success("存在未完成的订单,不允许下架！",goodsVOList);
        }
    }

    /**
     * @Description shelfGoods 定时下架到期资产
     */
    @RequestMapping(value = "/shelfGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse shelfGoods(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是："+day+"----");
        logger.debug("参数----"+day);
        if(day>0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取资产到期数据
            LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, 0);
            List<GoodsEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.debug("开始循环设置----"+list.size());
                List<GoodsEntity> listUp = new ArrayList<>();
                Map<Long,List<GoodsEntity>> map = new HashMap<>();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ,entity.getId()));
                    queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
                    List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
                    if(null==listOrder||listOrder.size()<=0){  //不存在未完成订单，可下架
                        logger.debug("开始设置下架----");
                        entity.setStatus(1);//下架
                        entity.setLowerType(2);//下架类型0-手动下架，1-售罄下架，2-到期下架
                        entity.setLower(99999L);
                        entity.setLowerTime(DateFormater.getCurrentDate());
                        listUp.add(entity);
                        //为发消息做准备
                        if(map.containsKey(entity.getSeller())){
                            map.get(entity.getSeller()).add(entity);
                        }else{
                            List<GoodsEntity> listGoods = new ArrayList<>();
                            listGoods.add(entity);
                            map.put(entity.getSeller(),listGoods);
                        }

                    }
                });

                for(Map.Entry<Long,List<GoodsEntity>> entry : map.entrySet()){
                    // TO DO 定时到期下架消息发送
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    List<String> sender = new ArrayList<>();
                    sender.add(entry.getKey()+"");
                    logger.info("发送信息给发布人:>----------" + sender+baseHost);
                    String formurl = baseHost+"cscec5b-panhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=2&lowerTime="+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT);
                    String subject = "【资产盘活】您上架的物资有【"+entry.getValue().size()+"】件今日到期自动下架";
                    String content = "【资产盘活】您上架的物资有【"+entry.getValue().size()+"】件今日到期自动下架。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content);
                }
                if(CollectionUtils.isNotEmpty(listUp)){
                    service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "五局轻量化平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath+"cscec5b-panhuo-mobile/#/goodsManage?tab=1&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }


    /**
     * pc端，首页统计分析
     */
    @RequestMapping(value = "/orgStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportVO> orgStatistics(Long orgId) {
        ReportVO res = service.orgStatistics(orgId);
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * pc端，期间对比分析
     */
    @RequestMapping(value = "/periodStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> periodStatistics() {
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = service.periodStatistics(commonOrgIds);
        return  CommonResponse.success("查询成功！",res);
    }
    /**
     * pc端，比例分析
     */
    @RequestMapping(value = "/proportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> proportion(int type) {
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = service.proportion(commonOrgIds,type);
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * 下级单位使用分析
     */
    @RequestMapping(value = "/subordinateReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> subordinateReport() {
        List<ReportVO> res = new ArrayList<>();
        CommonResponse<List<OrgVO>> childrenOrg = orgApi.getDirectChildrenByPid(InvocationInfoProxy.getOrgId(), null);
        if(CollectionUtils.isNotEmpty(childrenOrg.getData())){
            childrenOrg.getData().forEach(e -> {
                ReportVO vo = service.orgStatistics(e.getId());
                vo.setOrgName(e.getName());
                res.add(vo);
            });
        }
        return  CommonResponse.success("查询成功！",res);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put(key, new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter(QueryParam.IN, childIds));
            }
        }
    }

}
