package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.panhuo.bean.*;
import com.ejianc.business.panhuo.service.*;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.InstoreHzVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.business.warn.vo.WarningParameterVO;
import com.ejianc.business.warn.vo.WarningVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("order")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IOrderService service;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IAddressService addressService;

    @Autowired
    private IAllotService allotService;

    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Autowired
    private IInstoreHzService iInstoreHzService;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IMaterialApi materialApi;

    @Autowired
    private IWarningApi warningApi;


    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    /**
     * @Description saveOrUpdate 买家下单
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
    	return CommonResponse.success("操作成功！",service.saveOrder(saveorUpdateVO));
    }

    /**
     * @Description saveOrUpdate 卖家确认订单
     */
    @RequestMapping(value = "/confirmerOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> confirmerOrder(@RequestBody OrderVO saveorUpdateVO) {
        service.confirmerOrder(saveorUpdateVO);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
    	OrderEntity orderEntity = service.selectById(id);
        GoodsEntity goodsEntity = goodsService.selectById(orderEntity.getGoodsId());
    	OrderVO vo = BeanMapper.map(orderEntity, OrderVO.class);
    	vo.setRemainingNums(goodsEntity.getRemainingNums());
    	vo.setRotatableNums(goodsEntity.getRotatableNums());
        vo.setOrdermny(format(vo.getOrdermny().doubleValue()));
        vo.setMny(format(vo.getMny().doubleValue()));
        //设置hour值方法一：通过closeOrderDate方法，进入此方法具体实现里面
        //Integer hour = service.closeOrderDate();
        //设置hour值方法二：不经过调度参数设置，直接在此处设定一个固定值672小时(28天)，对应12天.其它设置hour的地方不做修改，仍按方法一设置
        Integer hour = 672;
        logger.info("获取到的参数是："+hour+"----");
        if(null != vo){
            if(hour>0){
                    try {
                        //（）+ 168 - 现在时间 = 倒计时时间
                        String endDate =  reportGetDate(vo.getBuyTime(),"HOUR",hour);
                        vo.setCountDown(endDate);
                    }catch (Exception e){
                        e.printStackTrace();
                    }

            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 周转上架
     * @param id
     */
    @RequestMapping(value = "/queryShelfDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryShelfDetail(Long id) {
        OrderEntity orderEntity = service.selectById(id);
        GoodsEntity entity = goodsService.selectById(orderEntity.getGoodsId());
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);


        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("status", new Parameter(QueryParam.EQ,0));//在售，说明已点过周转上架，并且在售
        List<GoodsEntity> listGoods = goodsService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(listGoods)&&listGoods.size()>0){
            throw new BusinessException("该机具已周转上架，不可重复上架");
        }

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam2.getParams().put("status", new Parameter(QueryParam.EQ,1));//下架
        queryParam2.getParams().put("lowerType", new Parameter(QueryParam.EQ,1));//售罄下架，说明该机具已到别处项目，不可周转
        List<GoodsEntity> listGoods2 = goodsService.queryList(queryParam2,false);
        if(CollectionUtils.isNotEmpty(listGoods2)&&listGoods2.size()>0){
            throw new BusinessException("该机具已周转完成，不可周转");
        }
        vo.setId(IdWorker.getId());
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);

        vo.setPrice(null);
        vo.setDiscount(null);

        vo.setOriginalprice(orderEntity.getPrice());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRemainingNums(entity.getNums());
        vo.setRotatableNums(entity.getNums());

        vo.setType(1);
        vo.setOrderId(id);
        //周转上架需带出买方地址
        AddressEntity addressEntity = addressService.getById(orderEntity.getBuyAddressId());

        if (addressEntity!=null){
            vo.setAddressId(addressEntity.getId());
            vo.setAddress(addressEntity.getAddress());
            vo.setAddressName(addressEntity.getProjectName());
            vo.setProjectAddress(addressEntity.getProjectAddress());
            vo.setPhone(addressEntity.getPhone());
            vo.setName(addressEntity.getName());
            vo.setLat(addressEntity.getLat());
            vo.setLon(addressEntity.getLon());
            vo.setFirstLocation(addressEntity.getFirstLocation());
            vo.setSecondLocation(addressEntity.getSecondLocation());
            vo.setThirdLocation(addressEntity.getThirdLocation());
            vo.setFourthLocation(addressEntity.getFourthLocation());
            vo.setLocation(addressEntity.getLocation());

            vo.setProjectId(addressEntity.getProjectId());
            vo.setProjectName(addressEntity.getProjectName());
            vo.setOrgId(addressEntity.getOrgId());
            vo.setOrgName(addressEntity.getOrgName());
        }



//        if(CollectionUtils.isNotEmpty(vo.getImgsPath())){
//            vo.getImgsPath().forEach(e -> {
//                e.setSourceId(null);
//                e.setRowState("add");
//            });
//        }
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                entity.getId().toString(),
                "BT211111000000004",
                "imgUpload",
                vo.getId().toString(),
                "BT211111000000004",
                "imgUpload"
        );
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        if(CollectionUtils.isNotEmpty(vo.getLabels())){
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 校验是否可周转
     * @Param
     */
    @RequestMapping(value = "/checkTurnover", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkTurnover(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("status", new Parameter(QueryParam.EQ,0));//在售，说明已点过周转上架，并且在售
        List<GoodsEntity> listGoods = goodsService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(listGoods)&&listGoods.size()>0){
            return CommonResponse.error(5001,"该机具已周转上架，不可重复上架！");
        }

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam2.getParams().put("status", new Parameter(QueryParam.EQ,1));//下架
        queryParam2.getParams().put("lowerType", new Parameter(QueryParam.EQ,1));//售罄下架，说明该机具已到别处项目，不可周转
        List<GoodsEntity> listGoods2 = goodsService.queryList(queryParam2,false);
        if(CollectionUtils.isNotEmpty(listGoods2)&&listGoods2.size()>0){
            return CommonResponse.error(5001,"该机具已周转完成，不可周转！");
        }
        OrderEntity orderEntity = service.getById(id);
        GoodsEntity goodsEntity = goodsService.getById(orderEntity.getGoodsId());
        return CommonResponse.success("校验成功！;"+goodsEntity.getSourceType());
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询我的购买-预定中
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        Parameter onShelfType = param.getParams().get("onShelfType");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));//0-待确认，1-已完成，2-订单取消
        if(onShelfType != null ){
            param.getParams().put("onShelfType", new Parameter(QueryParam.EQ, onShelfType.getValue()));//上架类型：0-正常上架 1-预售上架
        }
        Parameter isMyBrought = param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("buyOrg", param);
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        //Integer hour = service.closeOrderDate();
        //同上设置时间为672小时(28天)
        Integer hour = 672;
        logger.info("获取到的参数是："+hour+"----");
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            if(hour>0){
                for(OrderVO orderVO :pageData.getRecords()){
                    try {
                        //（）+ 168 - 现在时间 = 倒计时时间
                        String endDate =  reportGetDate(orderVO.getBuyTime(),"HOUR",hour);
                        orderVO.setCountDown(endDate);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已取消
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 2));//0-待确认，1-已完成，2-订单取消
        Parameter isMyBrought = param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("buyOrg", param);

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderFinish(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        Parameter preSaleFlag = param.getParams().get("preSaleFlag");
        if(preSaleFlag != null){
            param.getParams().put("preSaleFlag", new Parameter(QueryParam.EQ, preSaleFlag.getValue()));
        }
        Parameter isMyBrought = param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("buyOrg", param);

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-待处理
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));//0-待确认，1-已完成，2-订单取消
        List<Long> billStateList = new ArrayList<>();
        billStateList.add(1L);
        billStateList.add(3L);
        Parameter onShelfType = param.getParams().get("onShelfType");
        if(onShelfType != null ){
            param.getParams().put("onShelfType", new Parameter(QueryParam.EQ, onShelfType.getValue()));//上架类型：0-正常上架 1-预售上架
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList ));//-1-暂存,0-自由态,1-提交态,2-审批中,3-审批通过,4-审批不通过,5-已提交未审批
        Parameter isMySell = param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if(null!=isMySell&&isMySell.getValue().toString().contains("0")&&isMySell.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("sellOrg", param);
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        //Integer hour = service.closeOrderDate();
        //同上设置时间为672小时(28天)
        Integer hour = 672;
        logger.info("获取到的参数是："+hour+"----");
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            if(hour>0){
                for(OrderVO orderVO :pageData.getRecords()){
                    try {
                        //（）+ 168 - 现在时间 = 倒计时时间
                        String endDate =  reportGetDate(orderVO.getBuyTime(),"HOUR",hour);
                        orderVO.setCountDown(endDate);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    // number:为正数是相加,为负数是相减
    public static String reportGetDate(Date d,String type,int number){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if(type.equals("YEAR")) calendar.add(Calendar.YEAR,number);
        if(type.equals("MONTH"))calendar.add(Calendar.MONTH,number);
        if(type.equals("DAY")) calendar.add(Calendar.DAY_OF_MONTH,number);
        if(type.equals("HOUR")) calendar.add(Calendar.HOUR_OF_DAY,number);

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = df.format(calendar.getTime());
        return date;
    }
    /**
     * @Description queryList 查询我的出售-已取消
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 2));//0-待确认，1-已完成，2-订单取消
        Parameter isMySell = param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if(null!=isMySell&&isMySell.getValue().toString().contains("0")&&isMySell.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        Parameter onShelfType = param.getParams().get("onShelfType");
        if(onShelfType != null){
            param.getParams().put("onShelfType", new Parameter(QueryParam.EQ, onShelfType.getValue()));
        }
        this.setOrgParam("sellOrg", param);

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellFinish(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        Parameter preSaleFlag = param.getParams().get("preSaleFlag");
        if(preSaleFlag != null){
            param.getParams().put("preSaleFlag", new Parameter(QueryParam.EQ, preSaleFlag.getValue()));
        }
        Parameter isMySell = param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if(null!=isMySell&&isMySell.getValue().toString().contains("0")&&isMySell.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("sellOrg", param);

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryOrderPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryOrderPage(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        Parameter preSaleFlag = param.getParams().get("preSaleFlag");
        if(preSaleFlag != null){
            param.getParams().put("preSaleFlag", new Parameter(QueryParam.EQ, preSaleFlag.getValue()));
        }
        Parameter isMyBrought = param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyBrought&&isMyBrought.getValue().toString().contains("1")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        Parameter isMySell = param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if(null!=isMySell&&isMySell.getValue().toString().contains("0")&&isMySell.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMySell&&isMySell.getValue().toString().contains("1")){
            param.getParams().put("seller", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam1(param);

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void setOrgParam1(QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                ComplexParam c1 = new ComplexParam();
                c1.setLogic(ComplexParam.AND);

                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("sellOrg", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c2);


                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("buyOrg", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c3);

                param.getComplexParams().add(c1);
            } else {
                param.getComplexParams().add(getPageQueryParamPC());
            }

        } else {
            param.getComplexParams().add(getPageQueryParamMobile());
        }
    }

    public ComplexParam getPageQueryParamPC() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("parentSellOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);


        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("parentBuyOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);

        return c1;
    }

    public ComplexParam getPageQueryParamMobile() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);


        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);

        return c1;
    }

    /**
     * @Description updateStatus 买家取消订单
     */
    @RequestMapping(value = "/updateBuyStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        if(entity.getVersion()!=saveorUpdateVO.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }
        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());

        if(entity.getType() == 1 && BooleanUtils.isTrue(goodsEntity.getPreSaleFlag())){
            goodsEntity.setSellNums(ComputeUtil.safeSub(goodsEntity.getSellNums(), entity.getNums()));//已成交
            goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
            goodsEntity.setRemainingNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums()));//剩余数量
            goodsEntity.setStatus(0);//在售
        }else{
            goodsEntity.setPreNums(ComputeUtil.safeSub(goodsEntity.getPreNums(), entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
        }

        // TO DO 确认订单消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(entity.getSeller()+"");//发布人
        logger.info("发送信息给发布人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/sellerManage/card?id="+entity.getId()+"&userid={userid}";
        String subject = "【资产盘活】您的订单【"+entity.getBillCode()+"】已被买家取消";
        String content = "【资产盘活】您的订单【"+entity.getBillCode()+"】已被买家取消。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        service.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);


        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(0);//取消类型，0=买家，1=卖家，2-超时
        entity.setCancelTime(DateFormater.getCurrentDate());

        goodsService.saveOrUpdate(goodsEntity,false);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description updateStatus 管理员取消订单
     */
    @RequestMapping(value = "/cancel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> cancle(@RequestBody OrderVO saveorUpdateVO){
        LambdaQueryWrapper<AllotEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AllotEntity::getOrderId,saveorUpdateVO.getId());
        queryWrapper.eq(AllotEntity::getDr,0);
        List<AllotEntity> list = allotService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该订单已生成调拨单，不允许取消！");
        }
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }

        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());

        if(entity.getType() == 1 && BooleanUtils.isTrue(goodsEntity.getPreSaleFlag())){
            goodsEntity.setSellNums(ComputeUtil.safeSub(goodsEntity.getSellNums(), entity.getNums()));//已成交
            goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
            goodsEntity.setRemainingNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums()));//剩余数量
            goodsEntity.setStatus(0);//在售
        }else{
            goodsEntity.setPreNums(ComputeUtil.safeSub(goodsEntity.getPreNums(), entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
            goodsEntity.setStatus(0);//在售
        }

        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(entity.getOrderUserId()+"");//预定人
        logger.info("发送信息给预定人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/buyOrder/card?id="+entity.getId()+"&userid={userid}";
        String subject = "【资产盘活】您的订单【"+entity.getBillCode()+"】已被管理员取消";
        String content = "【资产盘活】您的订单【"+entity.getBillCode()+"】已被管理员取消。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        service.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

        goodsService.saveOrUpdate(goodsEntity,false);
        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(3);//取消类型，0=买家，1=卖家，2-超时， 3-管理员取消
        entity.setCancelTime(DateFormater.getCurrentDate());

        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description updateStatus 卖家取消订单
     */
    @RequestMapping(value = "/updateSellStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateSellStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }
        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());

        if(entity.getType() == 1 && BooleanUtils.isTrue(goodsEntity.getPreSaleFlag())){
            goodsEntity.setSellNums(ComputeUtil.safeSub(goodsEntity.getSellNums(), entity.getNums()));//已成交
            goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
            goodsEntity.setRemainingNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums()));//剩余数量
            goodsEntity.setStatus(0);//在售
        }else{
            goodsEntity.setPreNums(ComputeUtil.safeSub(goodsEntity.getPreNums(), entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
        }

        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(entity.getOrderUserId()+"");//预定人
        logger.info("发送信息给预定人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/buyOrder/card?id="+entity.getId()+"&userid={userid}";
        String subject = "【资产盘活】您的订单【"+entity.getBillCode()+"】已被卖家取消";
        String content = "【资产盘活】您的订单【"+entity.getBillCode()+"】已被卖家取消。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        service.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

        goodsService.saveOrUpdate(goodsEntity,false);
        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(1);//取消类型，0=买家，1=卖家，2-超时
        entity.setCancelTime(DateFormater.getCurrentDate());

        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description closeOrder 定时关闭到期订单
     */
    @RequestMapping(value = "/closeOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse closeOrder(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        //定时任务参数http://wei.cscec5b.com.cn:9080/ejc-job-admin/jobinfo
        //在轻量化支撑中心的调度参数配置里面，搜索WARNING000044编码，发现设置的值是168小时
        //点击进入getWarningByCode方法，发现来自于ejc-task-web，于是查询数据库ejc-task的ejc-warning-setting表和ejc-warning-setting-parameter表，也可发现parameters值是168
        //int hour = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        //这里将倒计时写死为15天
        Integer hour = 360;
        logger.info("获取到的参数是："+hour+"----");
        if(hour>0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            //将比较时间calendar设置为hour小时前的时间
            calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - hour);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取求购到期数据
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            //比如七天前11点买的，确认时间为7天，那就应该在今天11点之前确认，而现在已经12点了，订单已经自动取消了，所以判断条件为订单的购买时间getBuyTime小于calendar.getTime()
            lambdachange.le(OrderEntity::getBuyTime, df.format(calendar.getTime()));
            lambdachange.eq(OrderEntity::getType, 0);
            List<OrderEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.info("开始循环设置----"+list.size());
                Map<Long,List<OrderEntity>> map = new HashMap<>();
                list.forEach(entity -> {
                    entity.setType(2); //0-待确认，1-已完成，2-订单取消
                    entity.setCancel("99999");//下架类型0-手动下架，1-售罄下架，2-到期下架
                    entity.setCancelName("到期自动取消");
                    entity.setCancelType(2);//取消类型，0=买家，1=卖家，2-超时
                    entity.setCancelTime(DateFormater.getCurrentDate());

                    GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
                    // to do 还原金额
                    BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                    BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
                    goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
                    goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
                    goodsService.updateById(goodsEntity);

                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    List<String> sender = new ArrayList<>();
                    sender.add(entity.getSeller()+"");
                    logger.info("发送信息给发布人:>----------" + sender);
                    String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
                    String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/sellerManage/card?id="+entity.getId()+"&userid={userid}";
                    String subject = "您的订单【"+entity.getBillCode()+"】到期未确认，已失效";
                    String content = "您的订单【"+entity.getBillCode()+"】到期未确认，已失效。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);


                    List<String> messageType2 = new ArrayList<>();
                    messageType2.add("sys");
                    messageType.add("wjy");
                    List<String> sender2 = new ArrayList<>();
                    sender2.add(entity.getOrderUserId()+"");
                    logger.info("预订人:>----------" + sender2);
                    String formurl2 = baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id="+entity.getId();
                    String mobileUrl2 = wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id="+entity.getId()+"&userid={userid}";
                    String subject2 = "【资产盘活】您的订单【"+entity.getBillCode()+"】卖家未及时确认已取消";
                    String content2 = "【资产盘活】您的订单【"+entity.getBillCode()+"】卖家未及时确认已取消。<a href=" + '"' + formurl2 + '"' + ">前往点击</a>";
                    this.sendMsg(messageType2, sender2, "notice", subject2, content2,mobileUrl2);

                });
                service.updateBatchById(list);
            }
        }
        return CommonResponse.success("运行成功！");
    }


    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "五局轻量化平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", url);
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    /**
     * 入库单同步
     * @return
     */
    @RequestMapping(value = "/syncInstore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> syncInstore(HttpServletRequest request) {
        String lastUpdateTime = request.getParameter("lastUpdateTime");
        return CommonResponse.success(service.syncInstore(lastUpdateTime));
    }

    /**
     * 更新入库单同步
     * @return
     */
    @RequestMapping(value = "/updateSyncInstore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> updateSyncInstore(HttpServletRequest request) {
        return CommonResponse.success(service.updateSyncInstore());
    }

    /**
     * NC入库单汇总参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/instoreHzRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreHzVO>> instoreHzRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        JSONObject jsonObject = new JSONObject();
        if(StringUtils.isNotEmpty(condition)){
            jsonObject = JSONObject.parseObject(condition);
        }

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        //模糊查询
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        String projectId = String.valueOf(jsonObject.get("pkProject"));//项目主键
        String projectName = "";//项目名称
        String orgName = "";//组织名称
        if(!StringUtils.isEmpty(projectId)){
            //查询项目主键
            //传递的项目主键查询sourceId
            List<Long> ids = new ArrayList<>();
            ids.add(Long.valueOf(projectId));
            CommonResponse<List<ProjectRegisterVO>> res =  projectApi.queryProjectByIds(ids);
            if(res.isSuccess()&&CollectionUtils.isNotEmpty(res.getData())){
                queryParam.getParams().put("pkProject", new Parameter(QueryParam.EQ, res.getData().get(0).getSourceId()));
                projectName = res.getData().get(0).getName();
                orgName = res.getData().get(0).getOrgName();
            }else{
                return CommonResponse.success("项目不存在!",null);
            }
        }else{
            return CommonResponse.success("项目不存在!",null);
        }
        IPage<InstoreHzEntity> pageData = iInstoreHzService.queryPage(queryParam,false);
        //替换项目、物料
        for(InstoreHzEntity instoreHzEntity : pageData.getRecords()){
            //项目信息
            instoreHzEntity.setPkProject(projectId);
            instoreHzEntity.setVprojectname(projectName);
            //组织名称
            instoreHzEntity.setOrgName(orgName);
            //物料信息
            CommonResponse<MaterialVO> matRes = materialApi.queryMaterialBySourceId(instoreHzEntity.getPkMaterial());
            if(matRes.isSuccess()) {
                MaterialVO materialVO = matRes.getData();
                instoreHzEntity.setCode(materialVO.getCode());
                instoreHzEntity.setName(materialVO.getName());
                instoreHzEntity.setTypeId(String.valueOf(materialVO.getCategoryId()));
                instoreHzEntity.setType(materialVO.getCategoryName());
                instoreHzEntity.setUnitName(materialVO.getUnitName());
                instoreHzEntity.setSpec(materialVO.getSpec());
                instoreHzEntity.setMeasname(materialVO.getCategoryName());
                instoreHzEntity.setPkMaterial(String.valueOf(materialVO.getId()));//更新物料主键
            }
        }

        IPage<InstoreHzVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), InstoreHzVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }

    /**
     * NC入库单汇总(手机端接口)
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/instoreHzList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstoreHzVO>> instoreHzList(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = true) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        JSONObject jsonObject = new JSONObject();
        jsonObject = JSONObject.parseObject(condition);

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        //模糊查询
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("pkMaterial");
        queryParam.getFuzzyFields().add("pkProject");
        queryParam.getFuzzyFields().add("pkOrg");
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("pkOrg", new Parameter(QueryParam.EQ, jsonObject.get("orgId")));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<InstoreHzEntity> pageData = iInstoreHzService.queryPage(queryParam,false);
        IPage<InstoreHzVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), InstoreHzVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            param.getParams().put(key, new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter(QueryParam.IN, childIds));
            }
        }
    }
    //保留两位小数
    public static BigDecimal format(double value){
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);//调用setScale方法进行数据格式化，保留两位小数，采用四舍五入规则
        return bd;
    }


    /**
     * @Description preSellWarn 预售到期预警
     */
    @RequestMapping(value = "/preSellWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse preSellWarn(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是："+day+"----");
        logger.debug("参数----"+day);
        if(day>0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取资产到期数据
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getOnShelfType, 1);
            lambdachange.eq(OrderEntity::getPreSaleFlag, true);
            lambdachange.le(OrderEntity::getPreSaleDate, df.format(calendar.getTime()));
            List<OrderEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.debug("开始循环设置----"+list.size());
                List<OrderEntity> listUp = new ArrayList<>();
                List<OrderEntity> sellerList = new ArrayList<>();
                List<OrderEntity> buyerList = new ArrayList<>();
                list.forEach(entity -> {
                    logger.debug("开始设置下架----");
                    entity.setOnShelfType(0);//改成正常上架
                    listUp.add(entity);
                    //为发消息做准备
                    sellerList.add(entity);
                    buyerList.add(entity);
                });

                for(OrderEntity orderEntity : sellerList){
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    List<String> sender = new ArrayList<>();
                    sender.add(orderEntity.getSeller()+"");
                    logger.info("发送信息给发布人:>----------" + sender+baseHost);
                    String formurl = baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    String subject = "【资产盘活】您预售的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易，请查看";
                    String content = "【资产盘活】您预售的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                for(OrderEntity orderEntity : buyerList){
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    List<String> sender = new ArrayList<>();
                    sender.add(orderEntity.getOrderUserId()+"");
                    logger.info("发送信息给发布人:>----------" + sender+baseHost);
                    String formurl = baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    String subject = "【资产盘活】您预定的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易，请查看";
                    String content = "【资产盘活】您预定的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                if(CollectionUtils.isNotEmpty(listUp)){
                    service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }


    /**
     * @Description preSellWarn 预售到期预警 手动执行
     */
    @RequestMapping(value = "/preSellWarnManual", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse preSellWarnManual(HttpServletRequest request) {
        String param = request.getParameter("param");
        //转换成int类型
        int day = Integer.parseInt(param);
//        JSONArray json = JSONArray.parseArray(param );
//        logger.info("获取到的参数JSON是："+param+"----");
//        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
//        logger.info("获取到的参数是："+day+"----");
        logger.debug("参数----"+day);
        if(day>0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取资产到期数据
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getOnShelfType, 1);
            lambdachange.eq(OrderEntity::getPreSaleFlag, true);
            lambdachange.le(OrderEntity::getPreSaleDate, df.format(calendar.getTime()));
            List<OrderEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.debug("开始循环设置----"+list.size());
                List<OrderEntity> listUp = new ArrayList<>();
                List<OrderEntity> sellerList = new ArrayList<>();
                List<OrderEntity> buyerList = new ArrayList<>();
                list.forEach(entity -> {
                    logger.debug("开始设置下架----");
                    entity.setOnShelfType(0);//改成正常上架
                    listUp.add(entity);
                    //为发消息做准备
                    sellerList.add(entity);
                    buyerList.add(entity);
                });

                for(OrderEntity orderEntity : sellerList){
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    List<String> sender = new ArrayList<>();
                    sender.add(orderEntity.getSeller()+"");
                    logger.info("发送信息给发布人:>----------" + sender+baseHost);
                    String formurl = baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    String subject = "【资产盘活】您预售的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易，请查看";
                    String content = "【资产盘活】您预售的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                for(OrderEntity orderEntity : buyerList){
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    List<String> sender = new ArrayList<>();
                    sender.add(orderEntity.getOrderUserId()+"");
                    logger.info("发送信息给发布人:>----------" + sender+baseHost);
                    String formurl = baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    String subject = "【资产盘活】您预定的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易，请查看";
                    String content = "【资产盘活】您预定的【" + orderEntity.getMaterialName() + "】订单即将到期完成交易。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                if(CollectionUtils.isNotEmpty(listUp)){
                    service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }

    /**
     * @Description 生成出门证
     */
    @RequestMapping(value = "/pushOpApply", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> pushOpApply(@RequestBody List<Long> ids) {
        return CommonResponse.success("生成出门证成功,请及时去出门证小程序暂存列表查看提交!", service.pushOpApply(ids));
    }
}
