package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.ConfigEntity;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IRecommendAnaService;
import com.ejianc.business.panhuo.vo.ConfigVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 调拨管理组织实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("recommendAna")
public class RecommendAnaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IRecommendAnaService service;

    /**
     * pc端，首页统计分析
     */
    @RequestMapping(value = "/recommendAnaIndex", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportVO> recommendAnaIndex(Long orgId, String startTime, String endTime) {
        ReportVO res = service.recommendAnaIndex(orgId, startTime, endTime);
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * pc端，智能推荐台账
     */
    @RequestMapping(value = "/recommendAnaPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> recommendAnaPage(Long orgId, String startTime, String endTime) {
        List<ReportVO> res = new ArrayList<>();

        if(null==orgId||orgId<=0){
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childrenOrg = orgApi.getDirectChildrenByPid(orgId, null);
        if(CollectionUtils.isNotEmpty(childrenOrg.getData())){
            childrenOrg.getData().forEach(e -> {
                ReportVO vo = service.recommendAnaIndex(e.getId(), startTime, endTime);
                vo.setOrgName(e.getName());
                vo.setOrgId(e.getId());
                res.add(vo);
            });
        }

        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * pc端，项目智能推荐明细
     *
     */
    @RequestMapping(value = "/recommendAnaProj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReportVO>> recommendAnaProj(Long orgId, String startTime, String endTime, String searchText,
                                                           @RequestParam(defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(defaultValue = "10") Integer pageSize) {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("buyProjectName");
        param.setSearchText(searchText);

        CommonResponse<OrgVO> orgVO = orgApi.getOneById(orgId);
        Integer orgType = orgVO.getData().getOrgType();
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)){
            param.getParams().put("buyOrg", new Parameter(QueryParam.EQ, orgId));
        } else {
            param.getParams().put("parentBuyOrg", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Page<ReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportVO> res = service.recommendAnaProj(page, wrapper, startTime, endTime);
        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(res);
        return  CommonResponse.success("查询成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        Long orgId = null;
        String startTime = null;
        String endTime = null;

        /** 模糊搜索配置字段示例 */
        // List<String> fuzzyFields = param.getFuzzyFields();
        // fuzzyFields.add("materialName");
        param.setPageIndex(1);
        param.setPageSize(10000);

        /** 获取param参数 */
        if (param.getParams().get("orgId") != null && param.getParams().get("orgId").getValue() != null) {
            orgId = Long.valueOf( param.getParams().get("orgId").getValue().toString() );
        }
        if (param.getParams().get("startTime") != null && param.getParams().get("startTime").getValue() != null) {
            startTime = param.getParams().get("startTime").getValue().toString();
        }
        if (param.getParams().get("endTime") != null && param.getParams().get("endTime").getValue() != null) {
            endTime = param.getParams().get("endTime").getValue().toString();
        }
        List<ReportVO> listExport = this.recommendAnaPage(orgId, startTime, endTime).getData();

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("recommendCorp-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelProjExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelProjExport(@RequestBody QueryParam param, HttpServletResponse response) {

        Long orgId = null;
        String startTime = null;
        String endTime = null;

        /** 获取param参数 */
        if (param.getParams().get("orgId") != null && param.getParams().get("orgId").getValue() != null) {
            orgId = Long.valueOf( param.getParams().get("orgId").getValue().toString() );
        }
        if (param.getParams().get("startTime") != null && param.getParams().get("startTime").getValue() != null) {
            startTime = param.getParams().get("startTime").getValue().toString();
        }
        if (param.getParams().get("endTime") != null && param.getParams().get("endTime").getValue() != null) {
            endTime = param.getParams().get("endTime").getValue().toString();
        }
        List<ReportVO> listExport = this.recommendAnaProj(orgId, startTime, endTime, param.getSearchText(), 1, 10000).getData().getRecords();

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("recommendProj-export.xlsx", beans, response);
    }
}


